/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.queries.filters.EClassFilter;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideService;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class GenericShowHide
extends AbstractShowHide {
    protected IQueryFilter filter;
    protected IQueryContext qcontext = new QueryContext();

    public GenericShowHide(DDiagramContents content, EClass eClass) {
        this(content, eClass, (IQueryFilter)new EClassFilter(eClass));
    }

    public GenericShowHide(DDiagramContents content, EClass eClass, EStructuralFeature feature) {
        this(content, eClass, (IQueryFilter)new EClassFilter(eClass));
    }

    public GenericShowHide(DDiagramContents content, EClass eClass, IQueryFilter filter) {
        super(content);
        this.filter = filter;
    }

    public static GenericShowHide createGenericShowHide(EClass eClass, DDiagramContents content) {
        return new GenericShowHide(content, eClass);
    }

    public static GenericShowHide createGenericShowHide(EClass eClass, DDiagramContents content, IQueryFilter filter) {
        return new GenericShowHide(content, eClass, filter);
    }

    protected boolean isConcerned(EObject object) {
        return this.filter == null || this.filter.keepElement((Object)object, this.qcontext);
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic, AbstractShowHide.DiagramContext context, Collection<DSemanticDecorator> targetViews) {
        if (this.isConcerned(semantic)) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic, context, targetViews);
    }

    @Override
    protected DiagramElementMapping getMapping(EObject semantic, AbstractShowHide.DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        if (this.isConcerned(semantic)) {
            DSemanticDecorator containerView;
            DiagramElementMapping mapping = ShowHideService.getService().getMapping(semantic.eClass(), this.getContent().getDDiagram());
            EObject container = context.getLast("container") != null ? context.getLast("container").getValue() : null;
            DSemanticDecorator dSemanticDecorator = containerView = relatedViews.get("container").isEmpty() ? null : (DSemanticDecorator)relatedViews.get("container").iterator().next();
            if (SiriusElementMappingSpecOperations.checkPrecondition((DiagramElementMapping)mapping, (EObject)semantic, (EObject)container, (EObject)containerView)) {
                return mapping;
            }
        }
        return null;
    }

    @Override
    protected HashMapSet<String, EObject> getRelatedObjects(EObject semantic, AbstractShowHide.DiagramContext context) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic, context);
        AbstractShowHide.ContextItemElement lastContext = context.getLast();
        EObject lastCtxValue = lastContext.getValue();
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (this.isConcerned(lastCtxValue)) {
            result.add(semantic.eContainer());
        }
        value.put("container", result);
        return value;
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple, AbstractShowHide.DiagramContext context) {
        EObject semantic = originCouple.getValue();
        return this.isConcerned(semantic);
    }

    @Override
    protected boolean mustHide(DDiagramElement view, AbstractShowHide.DiagramContext context) {
        if (view.getDiagramElementMapping() instanceof AbstractNodeMapping) {
            return this.isConcerned(view.getTarget());
        }
        return true;
    }
}

