/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class RemoveInvalidFunctionalExchangeAllocations
extends AbstractReadWriteCommand {
    private ComponentExchange exchange;

    public RemoveInvalidFunctionalExchangeAllocations(ComponentExchange exchange) {
        this.exchange = exchange;
    }

    public String getName() {
        return "Remove invalid functional exchange allocations";
    }

    public void run() {
        final ArrayList<ComponentExchangeFunctionalExchangeAllocation> linksToRemove = new ArrayList<ComponentExchangeFunctionalExchangeAllocation>(1);
        EList allocatedExchanges = this.exchange.getAllocatedFunctionalExchanges();
        if (allocatedExchanges.size() < 1) {
            return;
        }
        EList links = this.exchange.getOwnedComponentExchangeFunctionalExchangeAllocations();
        List availableExhcnage = ComponentExchangeExt.getValidFEAvailableForAllocation((ComponentExchange)this.exchange);
        if (availableExhcnage != null && allocatedExchanges != null) {
            for (FunctionalExchange allocatedExchange : allocatedExchanges) {
                if (availableExhcnage.contains(allocatedExchange)) continue;
                for (ComponentExchangeFunctionalExchangeAllocation link : links) {
                    FunctionalExchange targetExchange = link.getAllocatedFunctionalExchange();
                    if (allocatedExchange == null || !allocatedExchange.equals(targetExchange)) continue;
                    linksToRemove.add(link);
                }
            }
        }
        final boolean[] flag = new boolean[1];
        final ExecutionManager em = TransactionHelper.getExecutionManager(linksToRemove);
        AbstractReadWriteCommand abstrctCommand = new AbstractReadWriteCommand(){

            public void run() {
                CapellaDeleteCommand command;
                boolean confirmDeletion;
                if (!linksToRemove.isEmpty() && (confirmDeletion = CapellaDeleteCommand.confirmDeletion((ExecutionManager)em, (Collection)linksToRemove)) && (command = new CapellaDeleteCommand(em, (Collection)linksToRemove, false, false, true)).canExecute()) {
                    command.execute();
                    flag[0] = true;
                }
            }
        };
        em.execute((ICommand)abstrctCommand);
    }
}

