/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.target;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.osgi.framework.BundleException;

public class TargetBundle {
    public static final int STATUS_PLUGIN_DOES_NOT_EXIST = 100;
    public static final int STATUS_FEATURE_DOES_NOT_EXIST = 110;
    public static final int STATUS_VERSION_DOES_NOT_EXIST = 101;
    public static final int STATUS_INVALID_MANIFEST = 102;
    protected BundleInfo fInfo;
    protected boolean fIsFragment = false;
    protected BundleInfo fSourceTarget;
    protected String fSourcePath = null;

    public TargetBundle(File bundleLocation) throws CoreException {
        this.initialize(bundleLocation);
    }

    protected TargetBundle() {
        this.fInfo = new BundleInfo();
    }

    public BundleInfo getBundleInfo() {
        return this.fInfo;
    }

    public IStatus getStatus() {
        return Status.OK_STATUS;
    }

    public boolean isSourceBundle() {
        return this.fSourceTarget != null;
    }

    public BundleInfo getSourceTarget() {
        return this.fSourceTarget;
    }

    public boolean isFragment() {
        return this.fIsFragment;
    }

    public String getSourcePath() {
        return this.fSourcePath;
    }

    private void initialize(File file) throws CoreException {
        if (file == null || !file.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.TargetFeature_FileDoesNotExist, (Object)file)));
        }
        Map<String, String> manifest = ManifestUtils.loadManifest(file);
        try {
            ManifestElement[] elements;
            this.fInfo = new BundleInfo(file.toURI());
            String header = manifest.get("Bundle-SymbolicName");
            if (header != null && (elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)header)) != null) {
                String name = elements[0].getValue();
                if (name != null) {
                    this.fInfo.setSymbolicName(name);
                    header = manifest.get("Bundle-Version");
                    if (header != null && (elements = ManifestElement.parseHeader((String)"Bundle-Version", (String)header)) != null) {
                        this.fInfo.setVersion(elements[0].getValue());
                    }
                }
                this.fSourceTarget = this.getProvidedSource(file, name, manifest);
            }
            this.fIsFragment = manifest.containsKey("Fragment-Host");
        }
        catch (BundleException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 102, NLS.bind((String)Messages.TargetBundle_ErrorReadingManifest, (Object)file.getAbsolutePath()), (Throwable)e));
        }
    }

    private BundleInfo getProvidedSource(File bundle, String symbolicName, Map<String, String> manifest) {
        this.fSourcePath = null;
        if (manifest != null) {
            if (manifest.containsKey("Eclipse-SourceBundle")) {
                try {
                    ManifestElement[] manifestElements = ManifestElement.parseHeader((String)"Eclipse-SourceBundle", (String)manifest.get("Eclipse-SourceBundle"));
                    if (manifestElements != null) {
                        int j = 0;
                        while (j < manifestElements.length) {
                            ManifestElement currentElement = manifestElements[j];
                            String binaryPluginName = currentElement.getValue();
                            String versionEntry = currentElement.getAttribute("version");
                            if (binaryPluginName != null && binaryPluginName.length() > 0 && versionEntry != null && versionEntry.length() > 0) {
                                return new BundleInfo(binaryPluginName, versionEntry, null, -1, false);
                            }
                            ++j;
                        }
                    }
                }
                catch (BundleException e) {
                    PDECore.log(e);
                    return null;
                }
            }
            if (manifest.containsKey("Bundle-ClassPath")) {
                return null;
            }
        }
        if (bundle != null && symbolicName != null) {
            if (bundle.isFile()) {
                return null;
            }
            File pxml = new File(bundle, "plugin.xml");
            if (!pxml.exists()) {
                pxml = new File(bundle, "fragment.xml");
            }
            if (pxml.exists()) {
                IExtensionRegistry registry = RegistryFactory.createRegistry(null, (Object)this, (Object)this);
                String bogusDef = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.2\"?>\n<plugin><extension-point id=\"source\" name=\"source\"/>\n</plugin>";
                RegistryContributor pointContributor = new RegistryContributor("org.eclipse.pde.core", "org.eclipse.pde.core", null, null);
                registry.addContribution((InputStream)new ByteArrayInputStream(bogusDef.getBytes()), (IContributor)pointContributor, false, null, null, (Object)this);
                RegistryContributor contributor = new RegistryContributor(symbolicName, symbolicName, null, null);
                try {
                    registry.addContribution((InputStream)new BufferedInputStream(new FileInputStream(pxml)), (IContributor)contributor, false, null, null, (Object)this);
                    IExtension[] extensions = registry.getExtensions((IContributor)contributor);
                    int i = 0;
                    while (i < extensions.length) {
                        IExtension extension = extensions[i];
                        if ("org.eclipse.pde.core.source".equals(extension.getExtensionPointUniqueIdentifier())) {
                            IConfigurationElement[] elements = extension.getConfigurationElements();
                            if (elements.length == 1) {
                                this.fSourcePath = elements[0].getAttribute("path");
                            }
                            return new BundleInfo(null, null, bundle.toURI(), -1, false);
                        }
                        ++i;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer().append(this.getBundleInfo().toString());
        IStatus status = this.getStatus();
        if (status != null && !status.isOK()) {
            result.append(' ').append(status.toString());
        }
        return result.toString();
    }
}

