/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.commands;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.transition.common.commands.DefaultCommand;
import org.polarsys.capella.core.transition.system.helpers.SemanticHelper;

public class DeleteReplicaPreserveRelatedElementsCommand
extends DefaultCommand {
    public DeleteReplicaPreserveRelatedElementsCommand(Collection<?> selection, IProgressMonitor progressMonitor) {
        super(selection, progressMonitor);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void performTransformation(Collection<?> source) {
        HashSet<CatalogElement> elements = new HashSet<CatalogElement>();
        for (Object selected : SemanticHelper.getSemanticObjects(source)) {
            if (!(selected instanceof EObject)) continue;
            if (selected instanceof CatalogElement && ((CatalogElement)selected).getKind() != CatalogElementKind.REC) {
                elements.add((CatalogElement)selected);
                continue;
            }
            elements.addAll(ReplicableElementExt.getReferencingReplicas((EObject)((EObject)selected)));
        }
        CapellaDeleteCommand delete = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(elements), elements, true, !this.isHeadless(), true);
        delete.execute();
    }

    protected boolean isHeadless() {
        return true;
    }
}

