/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.diffmerge.util.structures.AbstractBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.FLinkedList;
import org.eclipse.emf.diffmerge.util.structures.IEndorelation;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndorelation<T>
extends AbstractBinaryRelation<T, T>
implements IEndorelation<T> {
    protected AbstractEndorelation(IEqualityTester tester_p) {
        super(tester_p);
    }

    @Override
    public List<T> getTransitiveClosure(T element_p) {
        return this.getTransitiveClosure((Collection<? extends T>)Collections.singleton(element_p));
    }

    @Override
    public List<T> getTransitiveClosure(Collection<? extends T> elements_p) {
        FLinkedList result = new FLinkedList(this.getEqualityTester());
        FLinkedList<Object> toExplore = new FLinkedList<Object>(this.getEqualityTester());
        toExplore.addAll(elements_p);
        while (!toExplore.isEmpty()) {
            Object current = toExplore.get(0);
            toExplore.remove(current);
            if (result.contains(current)) continue;
            int index = this.minIndexOfMappingElements(current, result);
            result.add(index, current);
            toExplore.addAll(this.get(current));
        }
        result.removeAll(elements_p);
        return Collections.unmodifiableList(result);
    }

    private int minIndexOfMappingElements(T element_p, List<T> elements_p) {
        int size;
        int result = size = elements_p.size();
        int currentIndex = 0;
        Iterator<T> it = elements_p.iterator();
        while (result == size && it.hasNext()) {
            T current = it.next();
            Collection mapped = this.get(current);
            if (mapped.contains(element_p)) {
                result = currentIndex;
            }
            ++currentIndex;
        }
        return result;
    }
}

