/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part.listener;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class VisibilityPostCommitListener
extends ResourceSetListenerImpl {
    private DiagramEditPart diagramEditPart;

    public VisibilityPostCommitListener(DiagramEditPart diagramEditPart) {
        this.diagramEditPart = diagramEditPart;
        diagramEditPart.getEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this.disableVisibilityUpdater();
        this.forceNodeAndEdgeEditPartsRefresh(event);
    }

    private void disableVisibilityUpdater() {
        DDiagram dDiagram = this.getDDiagram();
        if (dDiagram != null) {
            NotificationUtil.sendNotification((EObject)dDiagram, (int)1, (int)5);
        }
    }

    private void forceNodeAndEdgeEditPartsRefresh(ResourceSetChangeEvent event) {
        Set<View> changedElements = this.getElementsWhoseVisibilityChanged(event);
        final HashSet parts = Sets.newHashSet();
        for (View view : changedElements) {
            Option<IGraphicalEditPart> elementParts = this.getEditPartsFor(view);
            if (!elementParts.some()) continue;
            parts.add((IGraphicalEditPart)elementParts.get());
        }
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DEdgeEditPart edgePart : Iterables.filter((Iterable)parts, DEdgeEditPart.class)) {
                    Option targetPart;
                    Edge edge = (Edge)edgePart.getNotationView();
                    Option sourcePart = VisibilityPostCommitListener.this.getEditPartsFor(edge.getSource());
                    if (sourcePart.some()) {
                        ((IGraphicalEditPart)sourcePart.get()).refresh();
                    }
                    if (!(targetPart = VisibilityPostCommitListener.this.getEditPartsFor(edge.getTarget())).some()) continue;
                    ((IGraphicalEditPart)targetPart.get()).refresh();
                }
            }
        });
    }

    private Option<IGraphicalEditPart> getEditPartsFor(View view) {
        Option result = Options.newNone();
        if (this.diagramEditPart != null && this.diagramEditPart.getRoot() != null && this.diagramEditPart.getViewer() != null && this.diagramEditPart.getViewer().getEditPartRegistry() != null) {
            Map registry = this.diagramEditPart.getViewer().getEditPartRegistry();
            if (view != null && registry.containsKey(view) && registry.get(view) instanceof IGraphicalEditPart) {
                result = Options.newSome((Object)((IGraphicalEditPart)registry.get(view)));
            }
        }
        return result;
    }

    private Set<View> getElementsWhoseVisibilityChanged(ResourceSetChangeEvent event) {
        Iterable<Notification> changes = this.getVisibilityChanges(event);
        HashSet result = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(changes, (Function)new Function<Notification, View>(){

            public View apply(Notification from) {
                if (from.getNotifier() instanceof View) {
                    return (View)from.getNotifier();
                }
                return null;
            }
        }), (Predicate)Predicates.notNull()));
        return result;
    }

    private Iterable<Notification> getVisibilityChanges(ResourceSetChangeEvent event) {
        return Iterables.filter((Iterable)Iterables.filter((Iterable)event.getNotifications(), Notification.class), (Predicate)new Predicate<Notification>(){

            public boolean apply(Notification input) {
                return NotationPackage.eINSTANCE.getView_Visible().equals(input.getFeature()) && !input.isTouch() && input.getNewBooleanValue();
            }
        });
    }

    private DDiagram getDDiagram() {
        EObject element;
        DDiagram dDiagram = null;
        if (this.diagramEditPart != null && (element = this.diagramEditPart.getDiagramView().getElement()) instanceof DDiagram) {
            dDiagram = (DDiagram)element;
        }
        return dDiagram;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }
}

