/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.filters;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;

public class FiltersActivationAdapter
extends AdapterImpl {
    private StructuredViewer viewer;

    public void setViewer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
        }
    }

    private void update(DDiagram diagram, final FilterDescription filter, boolean activate) {
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FiltersActivationAdapter.this.viewer != null) {
                    FiltersActivationAdapter.this.viewer.update((Object)filter, null);
                }
            }
        });
    }

    private void update(DDiagram notifier, final Collection<FilterDescription> filters, boolean b) {
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FiltersActivationAdapter.this.viewer != null && filters != null) {
                    for (FilterDescription filter : filters) {
                        FiltersActivationAdapter.this.viewer.update((Object)filter, null);
                    }
                }
            }
        });
    }

    public void notifyChanged(Notification msg) {
        int featureID;
        Object notifier = msg.getNotifier();
        if (notifier instanceof DDiagram && (featureID = msg.getFeatureID(DDiagram.class)) == 15) {
            switch (msg.getEventType()) {
                case 3: {
                    FilterDescription filterToAdd = (FilterDescription)msg.getNewValue();
                    this.update((DDiagram)notifier, filterToAdd, true);
                    break;
                }
                case 5: {
                    Collection filtersToAdd = (Collection)msg.getNewValue();
                    this.update((DDiagram)notifier, filtersToAdd, true);
                    break;
                }
                case 4: {
                    FilterDescription filterToRemove = (FilterDescription)msg.getOldValue();
                    this.update((DDiagram)notifier, filterToRemove, false);
                    break;
                }
                case 6: {
                    Collection filtersToRemove = (Collection)msg.getOldValue();
                    this.update((DDiagram)notifier, filtersToRemove, false);
                    break;
                }
            }
        }
    }
}

