/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.re2rpl.activities;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.activities.InitializeDiffMergeActivity;
import org.polarsys.capella.common.re.constants.IReConstants;
import org.polarsys.capella.common.re.handlers.merge.AvoidMergeUnmodifiableCategoryFilter;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.re.handlers.traceability.ReConfiguration;
import org.polarsys.capella.common.re.merge.scope.ReSourceScope;
import org.polarsys.capella.common.re.merge.scope.ReTargetScope;
import org.polarsys.capella.common.re.re2rpl.merge.SuffixedElementPropagationCategoryFilter;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategoryItem;
import org.polarsys.capella.core.transition.common.handlers.merge.IMergeHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.CompoundTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.capella.core.transition.common.merge.scope.IModelScopeFilter;
import org.polarsys.capella.core.transition.common.merge.scope.PartialRootedModelScope;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeDiffMergeUpdateReplicaActivity
extends InitializeDiffMergeActivity {
    public static final String ID = InitializeDiffMergeUpdateReplicaActivity.class.getCanonicalName();

    public IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        ContextScopeHandlerHelper.getInstance((IContext)context).clear("capella.re.SOURCE__ADDED_ELEMENTS", context);
        ContextScopeHandlerHelper.getInstance((IContext)context).clear("capella.re.TARGET__ADDED_ELEMENTS", context);
        LinkedList<CatalogElement> elements = ReplicableElementHandlerHelper.getInstance(context).getListSources(context);
        if (elements.isEmpty()) {
            return Status.OK_STATUS;
        }
        CatalogElement esource = elements.removeFirst();
        HashSet<CatalogElement> targets = new HashSet<CatalogElement>();
        CatalogElement etarget = ReplicableElementHandlerHelper.getInstance(context).getInitialTarget(context);
        targets.add(etarget);
        targets.addAll(ReplicableElementHandlerHelper.getInstance(context).getAllUsedReplicableElements(etarget));
        Collection<CatalogElement> usedReplicable = ReplicableElementHandlerHelper.getInstance(context).getUsedReplicableElements(esource);
        usedReplicable.remove(esource);
        if (!usedReplicable.isEmpty() && !ReplicableElementHandlerHelper.getInstance(context).getListSourcesVisited(context).contains(esource)) {
            if (IReConstants.ENABLE_SUB_INSTANCIATION()) {
                elements.addFirst(esource);
                for (CatalogElement aO : usedReplicable) {
                    elements.addFirst(aO);
                }
            }
            ReplicableElementHandlerHelper.getInstance(context).getListSourcesVisited(context).add(esource);
        }
        for (CatalogElement target : targets) {
            if (!esource.equals(target.getOrigin())) continue;
            ReplicableElementHandlerHelper.getInstance(context).setTarget(context, target);
        }
        ReplicableElementHandlerHelper.getInstance(context).setSource(context, esource);
        return super._run(activityParams);
    }

    protected IStatus initializeReferenceScope(IContext context, ActivityParameters activityParams) {
        CatalogElement source = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        CatalogElement target = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        Collection scopeElements = OptionsHandlerHelper.getInstance((IContext)context).getCollectionValue(context, (String)context.get((Object)"_OS"), "merge_sourceScope", Collections.emptyList());
        scopeElements.remove(source);
        scopeElements.remove(target);
        ITraceabilityHandler handler = (ITraceabilityHandler)context.get((Object)"TSMH");
        ReSourceScope sourceScope = new ReSourceScope(source, handler, scopeElements, context);
        context.put((Object)"MERGE_SOURCE_SCOPE", (Object)sourceScope);
        ((PartialRootedModelScope)sourceScope).build(this.getReferenceFilter(context));
        return Status.OK_STATUS;
    }

    protected IStatus initializeTargetScope(IContext context, ActivityParameters activityParams) {
        CatalogElement source = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        CatalogElement target = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        Collection scopeElements = OptionsHandlerHelper.getInstance((IContext)context).getCollectionValue(context, (String)context.get((Object)"_OS"), "merge_targetScope", Collections.emptyList());
        scopeElements.remove(source);
        scopeElements.remove(target);
        ITraceabilityHandler handler = (ITraceabilityHandler)context.get((Object)"TTMH");
        ReTargetScope targetScope = new ReTargetScope(target, handler, scopeElements, context);
        context.put((Object)"MERGE_TARGET_SCOPE", (Object)targetScope);
        ((PartialRootedModelScope)targetScope).build(this.getTargetFilter(context));
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus initializeCategoriesHandlers(IContext context, IMergeHandler handler, ActivityParameters activityParams) {
        super.initializeCategoriesHandlers(context, handler, activityParams);
        handler.addCategory((ICategoryItem)new AvoidMergeUnmodifiableCategoryFilter(context), context);
        handler.addCategory((ICategoryItem)new SuffixedElementPropagationCategoryFilter(context), context);
        return Status.OK_STATUS;
    }

    protected IStatus initializeTraceabilitySourceHandler(IContext context, ActivityParameters activityParams) {
        return super.initializeTraceabilitySourceHandler(context, activityParams);
    }

    protected IStatus initializeTraceabilityTargetHandler(IContext context, ActivityParameters activityParams) {
        return super.initializeTraceabilityTargetHandler(context, activityParams);
    }

    protected IHandler createDefaultTraceabilitySourceHandler(IContext context) {
        CatalogElement source = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        ReConfiguration configuration = new ReConfiguration(source);
        return new CompoundTraceabilityHandler((ITraceabilityConfiguration)configuration);
    }

    protected IHandler createDefaultTraceabilityTargetHandler(IContext context) {
        CatalogElement source = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        CatalogElement target = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        ReConfiguration configuration = new ReConfiguration(source, target);
        return new CompoundTraceabilityHandler((ITraceabilityConfiguration)configuration);
    }

    protected IModelScopeFilter getReferenceFilter(final IContext context) {
        return new IModelScopeFilter(){

            public boolean accepts(EObject element) {
                return ((ReSourceScope)((Object)context.get((Object)"MERGE_SOURCE_SCOPE"))).getInitialElements().contains(element);
            }
        };
    }

    protected IModelScopeFilter getTargetFilter(final IContext context) {
        return new IModelScopeFilter(){

            public boolean accepts(EObject element) {
                return ((ReTargetScope)((Object)context.get((Object)"MERGE_TARGET_SCOPE"))).getInitialElements().contains(element);
            }
        };
    }
}

