/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.model.helpers.InterfaceExt;

class ExchangeItemUpdater {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Refinement");

    ExchangeItemUpdater() {
    }

    static Collection<ExchangeItem> updateAddMissing(Interface iface, Collection<ExchangeItem> expected) {
        Collection<ExchangeItem> result = ExchangeItemUpdater.getAddedExchangeItems(iface, expected);
        for (ExchangeItem item : result) {
            ExchangeItemAllocation allocation = InterfaceExt.addExchangeItem((Interface)iface, (ExchangeItem)item);
            allocation.setName(item.getName());
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)new EmbeddedMessage(NLS.bind((String)"Element ''{0}'' has been allocated into ''{1}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)item), EObjectLabelProviderHelper.getText((EObject)iface)}), logger.getName(), (Object)new Object[]{item, iface}));
        }
        return result;
    }

    static Collection<ExchangeItem> getAddedExchangeItems(Interface i, Collection<ExchangeItem> expected) {
        return ExchangeItemUpdater.getAdded(expected, (Collection<ExchangeItem>)i.getExchangeItems());
    }

    static Collection<ExchangeItem> getRemovedExchangeItems(Interface i, Collection<ExchangeItem> expected) {
        return ExchangeItemUpdater.getRemoved(expected, (Collection<ExchangeItem>)i.getExchangeItems());
    }

    static void propagateExchangeItemsToFunctionPorts(FunctionalExchange fe) {
        for (ExchangeItem ei : fe.getExchangedItems()) {
            if (fe.getSourceFunctionOutputPort().getOutgoingExchangeItems().add((Object)ei) && logger.isInfoEnabled()) {
                logger.info((Object)new EmbeddedMessage(NLS.bind((String)"Exchange Item ''{0}'' is propagated to source port ''{1}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)ei), EObjectLabelProviderHelper.getText((EObject)fe.getSourceFunctionOutputPort())}), logger.getName(), (Object)new Object[]{ei, fe.getSourceFunctionOutputPort()}));
            }
            if (!fe.getTargetFunctionInputPort().getIncomingExchangeItems().add((Object)ei) || !logger.isInfoEnabled()) continue;
            logger.info((Object)new EmbeddedMessage(NLS.bind((String)"Exchange Item ''{0}'' is propagated to target port ''{1}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)ei), EObjectLabelProviderHelper.getText((EObject)fe.getTargetFunctionInputPort())}), logger.getName(), (Object)new Object[]{ei, fe.getTargetFunctionInputPort()}));
        }
    }

    private static Collection<ExchangeItem> getAdded(Collection<ExchangeItem> expected, Collection<ExchangeItem> actual) {
        LinkedHashSet<ExchangeItem> result = new LinkedHashSet<ExchangeItem>(expected);
        result.removeAll(actual);
        return result;
    }

    private static Collection<ExchangeItem> getRemoved(Collection<ExchangeItem> expected, Collection<ExchangeItem> actual) {
        LinkedHashSet<ExchangeItem> result = new LinkedHashSet<ExchangeItem>(actual);
        result.removeAll(expected);
        return result;
    }
}

