/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.association;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class AssociationConsistencyBetweenLayers
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        if (eType == EMFEventType.NULL && eObj instanceof Association) {
            Association ass = (Association)eObj;
            Collection linkedClassifiers = AssociationExt.getLinkedClassifiers((Association)ass);
            for (Classifier classifier : linkedClassifiers) {
                if (CapellaLayerCheckingExt.isElementFromCurrentOrUpperLayer((CapellaElement)classifier, (CapellaElement)ass)) continue;
                IStatus status = ctx_p.createFailureStatus(new Object[]{ass.getName(), classifier.getName(), classifier.eClass().getName()});
                statuses.add(status);
            }
        }
        if (statuses.isEmpty()) {
            return ctx_p.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
    }
}

