/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.association;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class AssociationEndsPrimitive
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Association) {
            Association association = (Association)eObj;
            ArrayList ownedRoles = new ArrayList(1);
            ownedRoles.addAll(association.getNavigableMembers());
            ownedRoles.addAll(association.getOwnedMembers());
            boolean isPrimitive = false;
            ArrayList<Object> primitiveEles = new ArrayList<Object>();
            for (Property property : ownedRoles) {
                Collection collection;
                AbstractType abstractType = property.getAbstractType();
                if (abstractType == null) continue;
                if (abstractType instanceof Class) {
                    Class cls = (Class)abstractType;
                    if (!cls.isIsPrimitive()) continue;
                    isPrimitive = true;
                    primitiveEles.add(cls);
                    continue;
                }
                if (!(abstractType instanceof Collection) || !(collection = (Collection)abstractType).isIsPrimitive()) continue;
                isPrimitive = true;
                primitiveEles.add(collection);
            }
            if (isPrimitive) {
                String strPrimitiveEls = "";
                Iterator iterator = primitiveEles.iterator();
                while (iterator.hasNext()) {
                    NamedElement next = (NamedElement)iterator.next();
                    strPrimitiveEls = String.valueOf(strPrimitiveEls) + next.getName();
                    if (!iterator.hasNext()) continue;
                    strPrimitiveEls = String.valueOf(strPrimitiveEls) + " , ";
                }
                return this.createFailureStatus(ctx, new Object[]{association.getName(), strPrimitiveEls});
            }
        }
        return ctx.createSuccessStatus();
    }
}

