/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.dataValue;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralStringValue;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.data.information.validation.dataValue.Messages;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class EnumerationLiteralDomainValueCheck
extends AbstractValidationRule {
    static final String EMPTY_STRING = "";

    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        if (eObj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)eObj;
            EList ownedLiterals = enumeration.getOwnedLiterals();
            for (EnumerationLiteral enumerationLiteral : ownedLiterals) {
                if (this.isSatisfiedBy(enumerationLiteral, enumeration)) continue;
                return ctx_p.createFailureStatus(new Object[]{eObj, this.typingState(enumeration), this.computeDiagnosticMessage(enumeration)});
            }
        }
        return ctx_p.createSuccessStatus();
    }

    public boolean isSatisfiedBy(EnumerationLiteral enumerationLiteral_p, Enumeration enum_p) {
        DataType domainType = enum_p.getDomainType();
        EList ownedLiterals = enum_p.getOwnedLiterals();
        if (ownedLiterals.isEmpty()) {
            return true;
        }
        if (domainType != null) {
            if (this.checkDefined((EList<EnumerationLiteral>)ownedLiterals) && this.ownedLiteralTypesAreConcordantWithEnumDomainType((EList<EnumerationLiteral>)ownedLiterals, domainType)) {
                return true;
            }
        } else {
            if (this.checkDefined((EList<EnumerationLiteral>)ownedLiterals) && this.areNumericValues((EList<EnumerationLiteral>)ownedLiterals)) {
                return true;
            }
            if (this.checkUndefined((EList<EnumerationLiteral>)ownedLiterals)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkDefined(EList<EnumerationLiteral> ownedLiterals_p) {
        for (EnumerationLiteral literal : ownedLiterals_p) {
            String valueLiteral;
            DataValue domainValue = literal.getDomainValue();
            if (domainValue == null) {
                return false;
            }
            DataValue value = this.getReferencedLiteralValue(domainValue);
            if (value instanceof LiteralBooleanValue) {
                return true;
            }
            if (!(value instanceof LiteralNumericValue ? this.isNull(valueLiteral = ((LiteralNumericValue)value).getValue(), true) || EMPTY_STRING.equals(valueLiteral) : value instanceof LiteralStringValue && (this.isNull(valueLiteral = ((LiteralStringValue)value).getValue(), true) || EMPTY_STRING.equals(valueLiteral)))) continue;
            return false;
        }
        return true;
    }

    private boolean checkUndefined(EList<EnumerationLiteral> ownedLiterals_p) {
        for (EnumerationLiteral literal : ownedLiterals_p) {
            String valueLiteral;
            DataValue domainValue = literal.getDomainValue();
            if (domainValue == null) continue;
            DataValue value = this.getReferencedLiteralValue(domainValue);
            if (value instanceof LiteralBooleanValue) {
                return false;
            }
            if (!(value instanceof LiteralNumericValue ? this.isNull(valueLiteral = ((LiteralNumericValue)value).getValue(), false) && !EMPTY_STRING.equals(valueLiteral) : value instanceof LiteralStringValue && this.isNull(valueLiteral = ((LiteralStringValue)value).getValue(), false) && !EMPTY_STRING.equals(valueLiteral))) continue;
            return false;
        }
        return true;
    }

    private boolean areNumericValues(EList<EnumerationLiteral> ownedLiterals_p) {
        for (EnumerationLiteral literal : ownedLiterals_p) {
            DataValue domainValue = literal.getDomainValue();
            DataValue value = this.getReferencedLiteralValue(domainValue);
            if (value instanceof NumericValue) continue;
            return false;
        }
        return true;
    }

    private TypeRelationship getRelationShip(EnumerationLiteral firstLiteral_p, DataType domainType_p) {
        if (this.ownedLiteralTypeIsConcordantWithEnumDomainType(firstLiteral_p, domainType_p, TypeRelationship.FIRST_UNTYPED)) {
            return TypeRelationship.FIRST_UNTYPED;
        }
        if (this.ownedLiteralTypeIsConcordantWithEnumDomainType(firstLiteral_p, domainType_p, TypeRelationship.SUBTYPE)) {
            return TypeRelationship.SUBTYPE;
        }
        return null;
    }

    private boolean ownedLiteralTypesAreConcordantWithEnumDomainType(EList<EnumerationLiteral> ownedLiterals_p, DataType domainType_p) {
        if (ownedLiterals_p.isEmpty()) {
            return true;
        }
        EnumerationLiteral firstLiteral = (EnumerationLiteral)ownedLiterals_p.get(0);
        TypeRelationship firstLiteralRelationShip = this.getRelationShip(firstLiteral, domainType_p);
        if (firstLiteralRelationShip == null) {
            return false;
        }
        List ownedLiteralsTail = ownedLiterals_p.subList(1, ownedLiterals_p.size());
        for (EnumerationLiteral literal : ownedLiteralsTail) {
            if (this.ownedLiteralTypeIsConcordantWithEnumDomainType(literal, domainType_p, firstLiteralRelationShip)) continue;
            return false;
        }
        return true;
    }

    private boolean ownedLiteralTypeIsConcordantWithEnumDomainType(EnumerationLiteral literal_p, DataType domainType_p, TypeRelationship relationship_p) {
        AbstractType type;
        DataValue domainValue = literal_p.getDomainValue();
        DataValue value = this.getReferencedLiteralValue(domainValue);
        return (value instanceof LiteralBooleanValue || value instanceof LiteralNumericValue || value instanceof LiteralStringValue) && this.areConcordantTypes(type = value.getAbstractType(), domainType_p, relationship_p);
    }

    private boolean areConcordantTypes(AbstractType type_p, DataType domainType_p, TypeRelationship relationshipCheck_p) {
        switch (relationshipCheck_p) {
            case FIRST_UNTYPED: {
                return type_p == null;
            }
            case SUBTYPE: {
                return this.isEqualOrSubtypeOf(type_p, domainType_p);
            }
        }
        return false;
    }

    private DataValue getReferencedLiteralValue(DataValue domainValue_p) {
        if (domainValue_p instanceof BooleanReference) {
            return this.getReferencedLiteralBooleanValue(domainValue_p);
        }
        if (domainValue_p instanceof NumericReference) {
            return this.getReferencedLiteralNumericValue(domainValue_p);
        }
        if (domainValue_p instanceof StringReference) {
            return this.getReferencedLiteralStringValue(domainValue_p);
        }
        return domainValue_p;
    }

    private LiteralBooleanValue getReferencedLiteralBooleanValue(DataValue domainValue_p) {
        Object ref = domainValue_p.eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getBooleanReference_ReferencedValue());
        while (ref instanceof BooleanReference && ((BooleanReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getBooleanReference_ReferencedValue()) != null) {
            ref = ((BooleanReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getBooleanReference_ReferencedValue());
        }
        if (ref instanceof LiteralBooleanValue) {
            return (LiteralBooleanValue)ref;
        }
        return null;
    }

    private LiteralStringValue getReferencedLiteralStringValue(DataValue domainValue_p) {
        Object ref = domainValue_p.eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getStringReference_ReferencedValue());
        while (ref instanceof StringReference && ((StringReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getStringReference_ReferencedValue()) != null) {
            ref = ((StringReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getStringReference_ReferencedValue());
        }
        if (ref instanceof LiteralStringValue) {
            return (LiteralStringValue)ref;
        }
        return null;
    }

    private LiteralNumericValue getReferencedLiteralNumericValue(DataValue domainValue_p) {
        Object ref = domainValue_p.eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedValue());
        while (ref instanceof NumericReference && ((NumericReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedValue()) != null) {
            ref = ((NumericReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedValue());
        }
        if (ref instanceof LiteralNumericValue) {
            return (LiteralNumericValue)ref;
        }
        return null;
    }

    private String computeDiagnosticMessage(Enumeration enum_p) {
        if (this.isTyped(enum_p)) {
            return Messages.EnumerationLiteralDomainValueCheck_typedEnum_diagnostic;
        }
        return Messages.EnumerationLiteralDomainValueCheck_unTypedEnum_diagnostic;
    }

    private String typingState(Enumeration enum_p) {
        return this.isTyped(enum_p) ? "typed" : "not typed";
    }

    private boolean isTyped(Enumeration enum_p) {
        return enum_p.getDomainType() != null;
    }

    private boolean isNull(Object elt_p, boolean expected_p) {
        if (elt_p == null) {
            return expected_p;
        }
        return !expected_p;
    }

    private boolean isEqualOrSubtypeOf(AbstractType type_p, DataType domainType_p) {
        if (domainType_p == null || type_p == null) {
            return false;
        }
        List subTypes = GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)domainType_p);
        if (subTypes.contains(type_p)) {
            return true;
        }
        return type_p.equals(domainType_p);
    }

    static enum TypeRelationship {
        FIRST_UNTYPED,
        SUBTYPE;

    }
}

