/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.exchangeitem;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.information.ElementKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ExchangeItemKind
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ExchangeItem) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            ExchangeItem exchangeItem = (ExchangeItem)eObj;
            ExchangeMechanism exchangeMechanism = exchangeItem.getExchangeMechanism();
            if (exchangeMechanism != null) {
                IStatus status;
                ElementKind exchangeItemElementKind;
                EList elements;
                String exchangeItemKindName = exchangeMechanism.getName();
                if (exchangeItemKindName != null && exchangeMechanism == ExchangeMechanism.OPERATION) {
                    elements = exchangeItem.getOwnedElements();
                    for (ExchangeItemElement exchangeItemElement : elements) {
                        exchangeItemElementKind = exchangeItemElement.getKind();
                        if (exchangeItemElementKind == ElementKind.MEMBER) continue;
                        status = ctx_p.createFailureStatus(new Object[]{exchangeItem, exchangeMechanism, exchangeItemElement.getName(), ElementKind.MEMBER});
                        statuses.add(status);
                    }
                }
                if (exchangeItemKindName != null && exchangeMechanism != ExchangeMechanism.OPERATION) {
                    elements = exchangeItem.getOwnedElements();
                    for (ExchangeItemElement exchangeItemElement : elements) {
                        exchangeItemElementKind = exchangeItemElement.getKind();
                        if (exchangeItemElementKind == ElementKind.TYPE) continue;
                        status = ctx_p.createFailureStatus(new Object[]{exchangeItem, exchangeMechanism, exchangeItemElement.getName(), ElementKind.TYPE});
                        statuses.add(status);
                    }
                }
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

