/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.union;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.UnionKind;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class UnionDiscriminantDataValue
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Union) {
            Union union = (Union)eObj;
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            if (union.getKind() == UnionKind.UNION) {
                UnionProperty discriminant = union.getDiscriminant();
                EList properties = union.getContainedUnionProperties();
                if (discriminant == null) {
                    return ctx_p.createSuccessStatus();
                }
                AbstractType abstractType = discriminant.getAbstractType();
                if (abstractType != null && abstractType instanceof DataType) {
                    DataType dataType = (DataType)abstractType;
                    EList ownedDataValues = dataType.getOwnedDataValues();
                    for (DataValue dataValue : ownedDataValues) {
                        Collection inverseReferencesOfEObject = CapellaElementExt.getInverseReferencesOfEObject((EObject)dataValue);
                        if (!inverseReferencesOfEObject.isEmpty()) {
                            boolean failureStaus = true;
                            for (EStructuralFeature.Setting setting : inverseReferencesOfEObject) {
                                UnionProperty uPro;
                                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                                EObject eObject = setting.getEObject();
                                boolean equals = eStructuralFeature.equals(InformationPackage.Literals.UNION_PROPERTY__QUALIFIER);
                                if (eObject == null || !(eObject instanceof UnionProperty) || !equals || !properties.contains((Object)(uPro = (UnionProperty)eObject)) || !uPro.getQualifier().contains((Object)dataValue)) continue;
                                failureStaus = false;
                            }
                            if (!failureStaus) continue;
                            statuses.add(this.createFailureStatus(ctx_p, new Object[]{dataValue.getName(), discriminant.getName(), union.getName()}));
                            continue;
                        }
                        statuses.add(this.createFailureStatus(ctx_p, new Object[]{dataValue.getName(), discriminant.getName(), union.getName()}));
                    }
                }
                if (statuses.size() > 0) {
                    return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
                }
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

