/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.union;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.model.helpers.DataValueExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class UnionPropertyQualifierConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof UnionProperty) {
            AbstractType discrProType;
            Union union;
            UnionProperty discrPro;
            UnionProperty unionPro = (UnionProperty)eObj;
            EObject container = unionPro.eContainer();
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            if (container != null && container instanceof Union && (discrPro = (union = (Union)container).getDiscriminant()) != null && (discrProType = discrPro.getAbstractType()) != null && discrProType instanceof DataType) {
                List allSubGeneralizableElements = GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)((DataType)discrProType));
                allSubGeneralizableElements.add((DataType)discrProType);
                EClass discrProTypeEClass = discrProType.eClass();
                EList qualifier = unionPro.getQualifier();
                for (DataValue dataValue : qualifier) {
                    AbstractType dataValueAbsType = dataValue.getAbstractType();
                    if (dataValueAbsType != null) {
                        boolean typeCheck = false;
                        for (GeneralizableElement genEle : allSubGeneralizableElements) {
                            EClass genEleEClass = genEle.eClass();
                            if (!dataValueAbsType.eClass().getName().equalsIgnoreCase(genEleEClass.getName())) continue;
                            typeCheck = true;
                        }
                        if (typeCheck) continue;
                        statuses.add(this.createFailureStatus(ctx_p, new Object[]{dataValue.getName(), dataValue.eClass().getName(), unionPro.getName(), discrProTypeEClass.getName()}));
                        continue;
                    }
                    if (DataValueExt.isDataValueConsitantWithDataType((DataValue)dataValue, (DataType)((DataType)discrProType))) continue;
                    statuses.add(this.createFailureStatus(ctx_p, new Object[]{dataValue.getName(), dataValue.eClass().getName(), unionPro.getName(), discrProTypeEClass.getName()}));
                }
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

