/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceProvider {
    private ITypeRoot fTypeRoot;
    private IDocument fDocument;
    private MethodDeclaration fDeclaration;
    private SourceAnalyzer fAnalyzer;
    private boolean fMustEvalReturnedExpression;
    private boolean fReturnValueNeedsLocalVariable;
    private List<Expression> fReturnExpressions;
    private IDocument fSource;
    private static final int EXPRESSION_MODE = 1;
    private static final int STATEMENT_MODE = 2;
    private static final int RETURN_STATEMENT_MODE = 3;
    private int fMarkerMode;

    public SourceProvider(ITypeRoot typeRoot, MethodDeclaration declaration) {
        this.fTypeRoot = typeRoot;
        this.fDeclaration = declaration;
        List parameters = this.fDeclaration.parameters();
        for (SingleVariableDeclaration element : parameters) {
            ParameterData data = new ParameterData(element);
            element.setProperty(ParameterData.PROPERTY, (Object)data);
        }
        this.fAnalyzer = new SourceAnalyzer(this.fTypeRoot, this.fDeclaration);
        this.fReturnValueNeedsLocalVariable = true;
        this.fReturnExpressions = new ArrayList<Expression>();
    }

    public SourceProvider(ITypeRoot typeRoot, IDocument source, MethodDeclaration declaration) {
        this(typeRoot, declaration);
        this.fSource = source;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        return this.fAnalyzer.checkActivation();
    }

    public void initialize() throws JavaModelException {
        ASTNode last;
        this.fDocument = this.fSource == null ? new Document(this.fTypeRoot.getBuffer().getContents()) : this.fSource;
        this.fAnalyzer.initialize();
        if (this.hasReturnValue() && (last = this.getLastStatement()) != null) {
            ReturnAnalyzer analyzer = new ReturnAnalyzer();
            last.accept((ASTVisitor)analyzer);
        }
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fAnalyzer.isExecutionFlowInterrupted();
    }

    public boolean isVariableReferenced(IVariableBinding binding) {
        VariableReferenceFinder finder = new VariableReferenceFinder(binding);
        this.fDeclaration.accept((ASTVisitor)finder);
        return finder.getResult();
    }

    public boolean hasReturnValue() {
        IMethodBinding binding = this.fDeclaration.resolveBinding();
        return binding.getReturnType() != this.fDeclaration.getAST().resolveWellKnownType("void");
    }

    public boolean hasArrayAccess() {
        return this.fAnalyzer.hasArrayAccess();
    }

    public boolean hasSuperMethodInvocation() {
        return this.fAnalyzer.hasSuperMethodInvocation();
    }

    public boolean mustEvaluateReturnedExpression() {
        return this.fMustEvalReturnedExpression;
    }

    public boolean returnValueNeedsLocalVariable() {
        return this.fReturnValueNeedsLocalVariable;
    }

    public int getNumberOfStatements() {
        return this.fDeclaration.getBody().statements().size();
    }

    public boolean isSimpleFunction() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() != 1) {
            return false;
        }
        return statements.get(0) instanceof ReturnStatement;
    }

    public boolean isLastStatementReturn() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() == 0) {
            return false;
        }
        return statements.get(statements.size() - 1) instanceof ReturnStatement;
    }

    public boolean isDangligIf() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() != 1) {
            return false;
        }
        ASTNode p = (ASTNode)statements.get(0);
        while (!(p instanceof IfStatement)) {
            ChildPropertyDescriptor childD;
            if (p instanceof WhileStatement) {
                childD = WhileStatement.BODY_PROPERTY;
            } else if (p instanceof ForStatement) {
                childD = ForStatement.BODY_PROPERTY;
            } else if (p instanceof EnhancedForStatement) {
                childD = EnhancedForStatement.BODY_PROPERTY;
            } else if (p instanceof DoStatement) {
                childD = DoStatement.BODY_PROPERTY;
            } else if (p instanceof LabeledStatement) {
                childD = LabeledStatement.BODY_PROPERTY;
            } else {
                return false;
            }
            Statement body = (Statement)p.getStructuralProperty((StructuralPropertyDescriptor)childD);
            if (body instanceof Block) {
                return false;
            }
            p = body;
        }
        return ((IfStatement)p).getElseStatement() == null;
    }

    public MethodDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String getMethodName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getReturnType() {
        return this.fDeclaration.resolveBinding().getReturnType();
    }

    public List<Expression> getReturnExpressions() {
        return this.fReturnExpressions;
    }

    public boolean returnTypeMatchesReturnExpressions() {
        ITypeBinding returnType = this.getReturnType();
        for (Expression expression : this.fReturnExpressions) {
            if (Bindings.equals((IBinding)returnType, (IBinding)expression.resolveTypeBinding())) continue;
            return false;
        }
        return true;
    }

    public ParameterData getParameterData(int index) {
        SingleVariableDeclaration decl = (SingleVariableDeclaration)this.fDeclaration.parameters().get(index);
        return (ParameterData)decl.getProperty(ParameterData.PROPERTY);
    }

    public ITypeRoot getTypeRoot() {
        return this.fTypeRoot;
    }

    public boolean needsReturnedExpressionParenthesis(ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return NecessaryParenthesesChecker.needsParentheses(((ReturnStatement)last).getExpression(), parent, locationInParent);
        }
        return false;
    }

    public boolean returnsConditionalExpression() {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return ((ReturnStatement)last).getExpression() instanceof ConditionalExpression;
        }
        return false;
    }

    public int getReceiversToBeUpdated() {
        return this.fAnalyzer.getImplicitReceivers().size();
    }

    public boolean isVarargs() {
        return this.fDeclaration.isVarargs();
    }

    public int getVarargIndex() {
        return this.fDeclaration.parameters().size() - 1;
    }

    public TextEdit getDeleteEdit() {
        ASTRewrite rewriter = ASTRewrite.create((AST)this.fDeclaration.getAST());
        rewriter.remove((ASTNode)this.fDeclaration, null);
        return rewriter.rewriteAST(this.fDocument, this.fTypeRoot.getJavaProject().getOptions(true));
    }

    public String[] getCodeBlocks(CallContext context, ImportRewrite importRewrite) throws CoreException {
        int split;
        ASTNode last;
        ASTRewrite rewriter = ASTRewrite.create((AST)this.fDeclaration.getAST());
        this.replaceParameterWithExpression(rewriter, context, importRewrite);
        this.updateImplicitReceivers(rewriter, context);
        this.makeNamesUnique(rewriter, context.scope);
        this.updateTypeReferences(rewriter, context);
        this.updateStaticReferences(rewriter, context);
        this.updateTypeVariables(rewriter, context);
        this.updateMethodTypeVariable(rewriter, context);
        List<IRegion> ranges = null;
        ranges = this.hasReturnValue() ? (context.callMode == 41 ? this.getStatementRanges() : this.getExpressionRanges()) : ((last = this.getLastStatement()) != null && last.getNodeType() == 41 ? this.getReturnStatementRanges() : this.getStatementRanges());
        TextEdit dummy = rewriter.rewriteAST(this.fDocument, this.fTypeRoot.getJavaProject().getOptions(true));
        int size = ranges.size();
        RangeMarker[] markers = new RangeMarker[size];
        int i = 0;
        while (i < markers.length) {
            IRegion range = ranges.get(i);
            markers[i] = new RangeMarker(range.getOffset(), range.getLength());
            ++i;
        }
        if (size <= 1) {
            split = Integer.MAX_VALUE;
        } else {
            IRegion region = ranges.get(0);
            split = region.getOffset() + region.getLength();
        }
        TextEdit[] edits = dummy.removeChildren();
        int i2 = 0;
        while (i2 < edits.length) {
            TextEdit edit = edits[i2];
            int pos = edit.getOffset() >= split ? 1 : 0;
            markers[pos].addChild(edit);
            ++i2;
        }
        MultiTextEdit root = new MultiTextEdit(0, this.fDocument.getLength());
        root.addChildren((TextEdit[])markers);
        try {
            TextEditProcessor processor = new TextEditProcessor(this.fDocument, (TextEdit)root, 3);
            UndoEdit undo = processor.performEdits();
            String[] result = this.getBlocks(markers);
            processor = new TextEditProcessor(this.fDocument, (TextEdit)undo, 2);
            processor.performEdits();
            return result;
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        return new String[0];
    }

    private Expression createParenthesizedExpression(Expression newExpression, AST ast) {
        ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
        parenthesized.setExpression(newExpression);
        return parenthesized;
    }

    private void replaceParameterWithExpression(ASTRewrite rewriter, CallContext context, ImportRewrite importRewrite) throws CoreException {
        Expression[] arguments = context.arguments;
        try {
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(context.compilationUnit);
            int i = 0;
            while (i < arguments.length) {
                block12: {
                    Expression expression = arguments[i];
                    String expressionString = null;
                    if (expression instanceof SimpleName) {
                        expressionString = ((SimpleName)expression).getIdentifier();
                    } else {
                        try {
                            expressionString = buffer.getDocument().get(expression.getStartPosition(), expression.getLength());
                        }
                        catch (BadLocationException exception) {
                            JavaPlugin.log(exception);
                            break block12;
                        }
                    }
                    ParameterData parameter = this.getParameterData(i);
                    List<SimpleName> references = parameter.references();
                    for (ASTNode aSTNode : references) {
                        Expression newExpression = (Expression)rewriter.createStringPlaceholder(expressionString, expression.getNodeType());
                        AST ast = rewriter.getAST();
                        ITypeBinding explicitCast = ASTNodes.getExplicitCast(expression, (Expression)aSTNode);
                        if (explicitCast != null) {
                            CastExpression cast = ast.newCastExpression();
                            if (NecessaryParenthesesChecker.needsParentheses(expression, (ASTNode)cast, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                                newExpression = this.createParenthesizedExpression(newExpression, ast);
                            }
                            cast.setExpression(newExpression);
                            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)expression, importRewrite);
                            cast.setType(importRewrite.addImport(explicitCast, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext));
                            expression = newExpression = cast;
                        }
                        if (NecessaryParenthesesChecker.needsParentheses(expression, aSTNode.getParent(), aSTNode.getLocationInParent())) {
                            newExpression = this.createParenthesizedExpression(newExpression, ast);
                        }
                        rewriter.replace(aSTNode, (ASTNode)newExpression, null);
                    }
                }
                ++i;
            }
        }
        finally {
            RefactoringFileBuffers.release(context.compilationUnit);
        }
    }

    private void makeNamesUnique(ASTRewrite rewriter, CodeScopeBuilder.Scope scope) {
        Collection<SourceAnalyzer.NameData> usedCalleeNames = this.fAnalyzer.getUsedNames();
        for (SourceAnalyzer.NameData nd : usedCalleeNames) {
            if (!scope.isInUse(nd.getName())) continue;
            String newName = scope.createName(nd.getName(), true);
            List<SimpleName> references = nd.references();
            for (SimpleName element : references) {
                ASTNode newNode = rewriter.createStringPlaceholder(newName, 42);
                rewriter.replace((ASTNode)element, newNode, null);
            }
        }
    }

    private void updateImplicitReceivers(ASTRewrite rewriter, CallContext context) {
        if (context.receiver == null) {
            return;
        }
        List<Expression> implicitReceivers = this.fAnalyzer.getImplicitReceivers();
        for (ASTNode aSTNode : implicitReceivers) {
            Expression receiver;
            IVariableBinding vb;
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(aSTNode, context.importer);
            if (aSTNode instanceof MethodInvocation) {
                MethodInvocation inv = (MethodInvocation)aSTNode;
                rewriter.set((ASTNode)inv, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, (IMethodBinding)inv.getName().resolveBinding(), (ImportRewrite.ImportRewriteContext)importRewriteContext), null);
                continue;
            }
            if (aSTNode instanceof ClassInstanceCreation) {
                ClassInstanceCreation inst = (ClassInstanceCreation)aSTNode;
                rewriter.set((ASTNode)inst, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, inst.resolveConstructorBinding(), (ImportRewrite.ImportRewriteContext)importRewriteContext), null);
                continue;
            }
            if (aSTNode instanceof ThisExpression) {
                rewriter.replace(aSTNode, rewriter.createStringPlaceholder(context.receiver, 32), null);
                continue;
            }
            if (aSTNode instanceof FieldAccess) {
                FieldAccess access = (FieldAccess)aSTNode;
                rewriter.set((ASTNode)access, (StructuralPropertyDescriptor)FieldAccess.EXPRESSION_PROPERTY, (Object)this.createReceiver(rewriter, context, access.resolveFieldBinding(), (ImportRewrite.ImportRewriteContext)importRewriteContext), null);
                continue;
            }
            if (!(aSTNode instanceof SimpleName) || !(((SimpleName)aSTNode).resolveBinding() instanceof IVariableBinding) || !(vb = (IVariableBinding)((SimpleName)aSTNode).resolveBinding()).isField() || (receiver = this.createReceiver(rewriter, context, vb, (ImportRewrite.ImportRewriteContext)importRewriteContext)) == null) continue;
            FieldAccess access = aSTNode.getAST().newFieldAccess();
            ASTNode target = rewriter.createMoveTarget(aSTNode);
            access.setName((SimpleName)target);
            access.setExpression(receiver);
            rewriter.replace(aSTNode, (ASTNode)access, null);
        }
    }

    private void updateTypeReferences(ASTRewrite rewriter, CallContext context) {
        ImportRewrite importer = context.importer;
        for (Name name : this.fAnalyzer.getTypesToImport()) {
            ITypeBinding binding = ASTNodes.getTypeBinding(name);
            if (binding == null || binding.isLocal()) continue;
            if (binding.isParameterizedType()) {
                binding = binding.getTypeDeclaration();
            }
            String s = importer.addImport(binding);
            if (ASTNodes.asString((ASTNode)name).equals(s)) continue;
            rewriter.replace((ASTNode)name, rewriter.createStringPlaceholder(s, 42), null);
        }
    }

    private void updateStaticReferences(ASTRewrite rewriter, CallContext context) {
        ImportRewrite importer = context.importer;
        for (Name name : this.fAnalyzer.getStaticsToImport()) {
            IBinding binding = name.resolveBinding();
            if (binding == null) continue;
            String s = importer.addStaticImport(binding);
            if (ASTNodes.asString((ASTNode)name).equals(s)) continue;
            rewriter.replace((ASTNode)name, rewriter.createStringPlaceholder(s, 42), null);
        }
    }

    private Expression createReceiver(ASTRewrite rewriter, CallContext context, IMethodBinding method, ImportRewrite.ImportRewriteContext importRewriteContext) {
        String receiver = this.getReceiver(context, method.getModifiers(), importRewriteContext);
        if (receiver == null) {
            return null;
        }
        return (Expression)rewriter.createStringPlaceholder(receiver, 32);
    }

    private Expression createReceiver(ASTRewrite rewriter, CallContext context, IVariableBinding field, ImportRewrite.ImportRewriteContext importRewriteContext) {
        String receiver = this.getReceiver(context, field.getModifiers(), importRewriteContext);
        if (receiver == null) {
            return null;
        }
        return (Expression)rewriter.createStringPlaceholder(receiver, 42);
    }

    private String getReceiver(CallContext context, int modifiers, ImportRewrite.ImportRewriteContext importRewriteContext) {
        String receiver = context.receiver;
        ITypeBinding invocationType = ASTNodes.getEnclosingType(context.invocation);
        ITypeBinding sourceType = this.fDeclaration.resolveBinding().getDeclaringClass();
        if (!context.receiverIsStatic && Modifier.isStatic((int)modifiers)) {
            receiver = "this".equals(receiver) && invocationType != null && Bindings.equals((IBinding)invocationType, (IBinding)sourceType) ? null : context.importer.addImport(sourceType, importRewriteContext);
        }
        return receiver;
    }

    private void updateTypeVariables(ASTRewrite rewriter, CallContext context) {
        ITypeBinding type = context.getReceiverType();
        if (type == null) {
            return;
        }
        this.rewriteReferences(rewriter, type.getTypeArguments(), this.fAnalyzer.getTypeParameterReferences());
    }

    private void updateMethodTypeVariable(ASTRewrite rewriter, CallContext context) {
        IMethodBinding method = Invocations.resolveBinding(context.invocation);
        if (method == null) {
            return;
        }
        this.rewriteReferences(rewriter, method.getTypeArguments(), this.fAnalyzer.getMethodTypeParameterReferences());
    }

    private void rewriteReferences(ASTRewrite rewriter, ITypeBinding[] typeArguments, List<SourceAnalyzer.NameData> typeParameterReferences) {
        if (typeArguments.length == 0) {
            return;
        }
        Assert.isTrue((typeArguments.length == typeParameterReferences.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < typeArguments.length) {
            SourceAnalyzer.NameData refData = typeParameterReferences.get(i);
            List<SimpleName> references = refData.references();
            String newName = typeArguments[i].getName();
            for (SimpleName name : references) {
                rewriter.replace((ASTNode)name, rewriter.createStringPlaceholder(newName, 42), null);
            }
            ++i;
        }
    }

    private ASTNode getLastStatement() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.isEmpty()) {
            return null;
        }
        return (ASTNode)statements.get(statements.size() - 1);
    }

    private List<IRegion> getReturnStatementRanges() {
        this.fMarkerMode = 3;
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size <= 1) {
            return result;
        }
        result.add(this.createRange(statements, size - 2));
        return result;
    }

    private List<IRegion> getStatementRanges() {
        this.fMarkerMode = 2;
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size == 0) {
            return result;
        }
        result.add(this.createRange(statements, size - 1));
        return result;
    }

    private List<IRegion> getExpressionRanges() {
        this.fMarkerMode = 1;
        ArrayList<IRegion> result = new ArrayList<IRegion>(2);
        List statements = this.fDeclaration.getBody().statements();
        ReturnStatement rs = null;
        int size = statements.size();
        switch (size) {
            case 0: {
                return result;
            }
            case 1: {
                ASTNode node = (ASTNode)statements.get(0);
                if (node.getNodeType() == 41) {
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(this.createRange(node, node));
                break;
            }
            default: {
                ASTNode node = (ASTNode)statements.get(size - 1);
                if (node.getNodeType() == 41) {
                    result.add(this.createRange(statements, size - 2));
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(this.createRange(statements, size - 1));
            }
        }
        if (rs != null) {
            Expression exp = rs.getExpression();
            result.add(this.createRange((ASTNode)exp, (ASTNode)exp));
        }
        return result;
    }

    private IRegion createRange(List<Statement> statements, int end) {
        ASTNode first = (ASTNode)statements.get(0);
        ASTNode last = (ASTNode)statements.get(end);
        return this.createRange(first, last);
    }

    private IRegion createRange(ASTNode first, ASTNode last) {
        ASTNode root = first.getRoot();
        if (root instanceof CompilationUnit) {
            CompilationUnit unit = (CompilationUnit)root;
            int start = unit.getExtendedStartPosition(first);
            int length = unit.getExtendedStartPosition(last) - start + unit.getExtendedLength(last);
            Region range = new Region(start, length);
            return range;
        }
        int start = first.getStartPosition();
        int length = last.getStartPosition() - start + last.getLength();
        Region range = new Region(start, length);
        return range;
    }

    private String[] getBlocks(RangeMarker[] markers) throws BadLocationException {
        String[] result = new String[markers.length];
        int i = 0;
        while (i < markers.length) {
            RangeMarker marker = markers[i];
            String content = this.fDocument.get(marker.getOffset(), marker.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, this.fTypeRoot.getJavaProject(), false);
            if (this.fMarkerMode == 2 && lines.length == 2 && this.isSingleControlStatementWithoutBlock()) {
                lines[1] = String.valueOf(CodeFormatterUtil.createIndentString(1, this.fTypeRoot.getJavaProject())) + lines[1];
            }
            result[i] = Strings.concatenate(lines, TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument));
            ++i;
        }
        return result;
    }

    private boolean isSingleControlStatementWithoutBlock() {
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size != 1) {
            return false;
        }
        Statement statement = (Statement)statements.get(size - 1);
        int nodeType = statement.getNodeType();
        if (nodeType == 25) {
            IfStatement ifStatement = (IfStatement)statement;
            return !(ifStatement.getThenStatement() instanceof Block) && !(ifStatement.getElseStatement() instanceof Block);
        }
        if (nodeType == 24) {
            return !(((ForStatement)statement).getBody() instanceof Block);
        }
        if (nodeType == 61) {
            return !(((WhileStatement)statement).getBody() instanceof Block);
        }
        return false;
    }

    private class ReturnAnalyzer
    extends ASTVisitor {
        private ReturnAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            Expression expression = node.getExpression();
            if (!ASTNodes.isLiteral(expression) && !(expression instanceof Name)) {
                SourceProvider.this.fMustEvalReturnedExpression = true;
            }
            if (Invocations.isInvocation((ASTNode)expression) || expression instanceof ClassInstanceCreation) {
                SourceProvider.this.fReturnValueNeedsLocalVariable = false;
            }
            SourceProvider.this.fReturnExpressions.add(expression);
            return false;
        }
    }

    static class VariableReferenceFinder
    extends ASTVisitor {
        private boolean fResult;
        private IVariableBinding fBinding;

        public VariableReferenceFinder(IVariableBinding binding) {
            this.fBinding = binding;
        }

        public boolean getResult() {
            return this.fResult;
        }

        public boolean visit(SimpleName node) {
            if (!this.fResult) {
                this.fResult = Bindings.equals((IBinding)this.fBinding, node.resolveBinding());
            }
            return false;
        }
    }
}

