/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.api.configuration;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.polarsys.kitalpha.cadence.core.api.CadenceRegistry;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.composer.api.CodeManagerCadenceLaunchConfiguration;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.api.library.LibraryReuseHelper;
import org.polarsys.kitalpha.composer.api.profiles.ComposerProfile;
import org.polarsys.kitalpha.composer.api.profiles.ParameterProfileElement;
import org.polarsys.kitalpha.composer.api.profiles.ParameterizedProfileElement;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.extension.points.IGenerator;
import org.polarsys.kitalpha.composer.extension.points.IRefinery;
import org.polarsys.kitalpha.composer.extension.points.IStrategy;
import org.polarsys.kitalpha.composer.extension.points.ParameterizedComposerElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationFactory {
    private static final ConfigurationFactory INSTANCE = new ConfigurationFactory();

    private ConfigurationFactory() {
    }

    public static ConfigurationFactory getInstance() {
        return INSTANCE;
    }

    public CodeManagerConfiguration create(ComposerProfile profile) throws CoreException {
        CodeManagerConfiguration configuration = new CodeManagerConfiguration();
        configuration.setStrategy((IStrategy)CodeManagerExtensions.getStrategyConfigElementFromId(profile.getStrategy().getId()).createExecutableExtension("Class"));
        this.initializeComposerParameter(configuration.getStrategyParameters(), profile.getStrategy(), configuration.getStrategy());
        configuration.setRefinery((IRefinery)CodeManagerExtensions.getRefineryConfigElementFromId(profile.getRefinery().getId()).createExecutableExtension("Class"));
        this.initializeComposerParameter(configuration.getRefineryParameters(), profile.getRefinery(), configuration.getRefinery());
        configuration.setGenerator((IGenerator)CodeManagerExtensions.getGeneratorConfigElementFromId(profile.getGenerator().getId()).createExecutableExtension("Class"));
        this.initializeComposerParameter(configuration.getGeneratorParameters(), profile.getGenerator(), configuration.getGenerator());
        configuration.setLibraries(LibraryReuseHelper.INSTANCE.getResourcesFromIds(profile.getLibraries()));
        configuration.setCodeManagerCadenceLaunchConfiguration(this.createCadenceConfiguration(profile));
        return configuration;
    }

    private CodeManagerCadenceLaunchConfiguration createCadenceConfiguration(ComposerProfile profile) {
        CodeManagerCadenceLaunchConfiguration cadenceConfiguration = new CodeManagerCadenceLaunchConfiguration();
        this.createCadenceActivities(profile.getBeforeStrategyActivities(), cadenceConfiguration.getBeforeStrategyActivities());
        this.createCadenceActivities(profile.getBeforeRefineryActivities(), cadenceConfiguration.getBeforeRefineryActivities());
        this.createCadenceActivities(profile.getBeforeGeneratorActivities(), cadenceConfiguration.getBeforeGenerationActivities());
        this.createCadenceActivities(profile.getAfterGeneratorActivities(), cadenceConfiguration.getAfterGenerationActivities());
        return cadenceConfiguration;
    }

    private void initializeComposerParameter(Map<String, Parameter> target, ParameterizedProfileElement profileElement, ParameterizedComposerElement composerElement) {
        if (composerElement.getParameters() == null) {
            return;
        }
        for (Map.Entry<String, Parameter> parameter : composerElement.getParameters().entrySet()) {
            Parameter parameterObj = parameter.getValue();
            target.put(parameter.getKey(), new Parameter(parameterObj.getName(), parameterObj.getValue(), parameterObj.getDescription()));
        }
        for (ParameterProfileElement parameterProfileElement : profileElement.getParameters()) {
            Parameter parameter = target.get(parameterProfileElement.getName());
            if (parameter == null) continue;
            parameter.setValue(parameterProfileElement.getValue());
        }
    }

    private void createCadenceActivities(Iterable<ParameterizedProfileElement> elements, WorkflowActivityParameter activities) {
        for (ParameterizedProfileElement activity : elements) {
            activities.addActivity(activity.getId());
            ActivityParameters activityParameters = new ActivityParameters();
            Collection natifParameters = CadenceRegistry.getIActivityClassFromId((String)activity.getId()).getParameters();
            if (natifParameters != null) {
                for (DeclaredParameter natifParameter : natifParameters) {
                    activityParameters.addParameter((GenericParameter)natifParameter);
                }
            }
            for (ParameterProfileElement parameterProfileElement : activity.getParameters()) {
                GenericParameter parameter = new GenericParameter(parameterProfileElement.getName(), (Object)parameterProfileElement.getValue(), "");
                activityParameters.addParameter(parameter);
            }
            activities.addParameter(activity.getId(), activityParameters);
        }
    }
}

