/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.internal.path.variables.common;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.polarsys.kitalpha.composer.api.path.variables.IComposerVariable;

public class ProjectDir
implements IComposerVariable {
    public String getName() {
        return "projectDir";
    }

    public String execute(Object obj) {
        Resource res;
        String replacement = "";
        if (obj instanceof File) {
            File file = (File)obj;
            replacement = this.findProject(file);
        }
        if (obj instanceof EObject) {
            EObject eObject = (EObject)obj;
            replacement = WorkspaceSynchronizer.getFile((Resource)eObject.eResource()).getProject().getLocation().toString();
        }
        if (obj instanceof Resource) {
            res = (Resource)obj;
            replacement = WorkspaceSynchronizer.getFile((Resource)res).getProject().getLocation().toString();
        }
        if (obj instanceof IResource) {
            res = (IResource)obj;
            replacement = res.getProject().getLocation().toString();
        }
        if (obj instanceof ResourceSet) {
            ResourceSet set = (ResourceSet)obj;
            EList resources = set.getResources();
            if (!resources.isEmpty()) {
                Resource first = (Resource)resources.get(0);
                replacement = this.execute(first);
            } else {
                String msg = "Your selection is empty";
                RuntimeException exception = new RuntimeException(msg);
                throw exception;
            }
        }
        return replacement;
    }

    private String findProject(File file) {
        String[] contents;
        String result = "";
        if (file.isDirectory() && (contents = file.list(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.equalsIgnoreCase(".project");
            }
        })).length > 0) {
            result = file.getAbsolutePath();
            return result;
        }
        result = this.findProject(file.getParentFile());
        return result;
    }
}

