/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.command.recorder.core.manager;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.polarsys.capella.common.command.recorder.core.exception.RecorderException;
import org.polarsys.capella.common.command.recorder.core.manager.IRecorderManager;
import org.polarsys.capella.common.command.recorder.core.manager.IRecorderObserver;
import org.polarsys.capella.common.command.recorder.core.manager.utils.RecorderManagerUtils;
import org.polarsys.capella.common.command.recorder.core.messages.RecorderMessages;
import org.polarsys.capella.common.command.recorder.core.output.DummyOutputManager;
import org.polarsys.capella.common.command.recorder.core.output.IOutputManager;
import org.polarsys.capella.common.command.recorder.core.output.OutputHelper;
import org.polarsys.capella.common.command.recorder.core.recorder.AbstractRecorder;
import org.polarsys.capella.common.command.recorder.core.recorder.IRecorder;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public abstract class AbstractRecorderManager
implements IRecorderManager,
IRecorderObserver,
IOperationHistoryListener {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("Default");
    private boolean _isStarted = false;
    protected IOperationHistory _history = OperationHistoryFactory.getOperationHistory();
    protected HistoryListenerControl _hlc;
    protected Set<AbstractRecorder> _recorders = null;
    private IOutputManager _outputManager = null;

    protected void initRecorders() {
        if (this._recorders == null) {
            this._recorders = new HashSet<AbstractRecorder>();
        } else {
            this.removeRecorders();
        }
    }

    public void addRecorder(AbstractRecorder recorder, boolean createNewRecord) {
        this._recorders.add(recorder);
        this._outputManager.registerRecorder(recorder, createNewRecord);
        for (TransactionalEditingDomain editingDomain : ExecutionManagerRegistry.getInstance().getAllEditingDomains()) {
            editingDomain.addResourceSetListener((ResourceSetListener)recorder);
        }
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)recorder);
    }

    public void removeRecorder(AbstractRecorder recorder) {
        this._recorders.remove(recorder);
        this._outputManager.removeRecorder(recorder);
        for (TransactionalEditingDomain editingDomain : ExecutionManagerRegistry.getInstance().getAllEditingDomains()) {
            editingDomain.removeResourceSetListener((ResourceSetListener)recorder);
        }
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)recorder);
    }

    protected void removeRecorders() {
        while (!this._recorders.isEmpty()) {
            this.removeRecorder(this._recorders.iterator().next());
        }
        if (this._recorders != null) {
            this._recorders.clear();
        }
    }

    public AbstractRecorderManager() {
        this.checkDirectory();
    }

    public boolean isStarted() {
        return this._isStarted;
    }

    private void checkDirectory() {
        File file = OutputHelper.getDir(null);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    protected void initOperation() {
        this._hlc.init();
        this.clearRecorders();
    }

    @Override
    public void switchState() {
        try {
            if (!this._isStarted) {
                this.startup();
            } else {
                this.shutDown();
            }
        }
        catch (RecorderException recorderException) {
            // empty catch block
        }
    }

    @Override
    public void startup() throws RecorderException {
        if (this._isStarted) {
            throw new RecorderException(RecorderMessages.abstractRecorderManager_alreadyStarted);
        }
        this._isStarted = true;
        this._history.addOperationHistoryListener((IOperationHistoryListener)this);
        this._hlc = new HistoryListenerControl();
        this.getOutputManager().init();
        this.initOperation();
        this.initRecorders();
        OutputHelper.cleanUpStorageAreaForRecords(this._recorders);
    }

    @Override
    public void shutDown() throws RecorderException {
        if (!this._isStarted) {
            throw new RecorderException(RecorderMessages.abstractRecorderManager_alreadyStopped);
        }
        this._isStarted = false;
        this._history.removeOperationHistoryListener((IOperationHistoryListener)this);
        this.removeRecorders();
        this._outputManager.dispose();
    }

    @Override
    public void recorderChanged(IRecorder recorder, Object object) {
        if (!this._hlc.isOperationInProgress()) {
            this._hlc.operationStarted(-1);
            this.initOperation();
        }
    }

    @Override
    public void clearRecorders() {
        if (this._recorders != null) {
            for (IRecorder iRecorder : this._recorders) {
                iRecorder.clearRecords();
            }
        }
    }

    public final void setOutPutManager(IOutputManager outputManager) {
        this._outputManager = outputManager != null ? outputManager : this.getOutputManager();
    }

    public final IOutputManager getOutputManager() {
        if (this._outputManager == null) {
            this._outputManager = new DummyOutputManager();
        }
        return this._outputManager;
    }

    public void historyNotification(OperationHistoryEvent event) {
        IUndoableOperation op = event.getOperation();
        int eventType = event.getEventType();
        switch (eventType) {
            case 1: 
            case 2: 
            case 3: {
                if (this._hlc.isOperationInProgress()) {
                    this._hlc.setDate(new Date());
                    this.write();
                    this.initOperation();
                }
                this._hlc.init();
                this._hlc.operationStarted(eventType);
                this._hlc.setDate(new Date());
                this._hlc.setLabel(op.getLabel());
                if (this._hlc.isValid()) break;
                this.initOperation();
                return;
            }
            case 4: 
            case 9: 
            case 10: {
                int expectedStartOps = -1;
                try {
                    expectedStartOps = RecorderManagerUtils.getExpectedOpeningEvent(eventType);
                }
                catch (RecorderException exception) {
                    this.initOperation();
                    return;
                }
                if (expectedStartOps != this._hlc.getStartingOperation()) {
                    this.initOperation();
                    return;
                }
                this.write();
                this.initOperation();
                break;
            }
            case 7: {
                this._hlc.setToKo();
                this.write();
                this.initOperation();
            }
        }
    }

    public abstract void writeOperation(Writer var1) throws IOException;

    @Override
    public void write() {
        try {
            Writer writer = null;
            for (IRecorder iRecorder : this._recorders) {
                if (iRecorder.isEmpty()) continue;
                writer = this._outputManager.getWriter(iRecorder);
                if (writer == null) {
                    __logger.info((Object)RecorderMessages.abstractRecorderManager_cannotwrite);
                    return;
                }
                this.writeOperation(writer);
                iRecorder.write(writer);
                writer.flush();
            }
        }
        catch (IOException exception) {
            __logger.info((Object)RecorderMessages.abstractRecorderManager_cannotwrite);
        }
    }

    protected class HistoryListenerControl {
        protected int[] _doublet;
        protected boolean _opInProgress;
        protected boolean _isValid;
        protected String _operationLabel;
        protected Date _date;
        protected static final int START_IDX = 0;
        protected static final int END_IDX = 1;

        public HistoryListenerControl() {
            this.init();
        }

        public void init() {
            this._doublet = new int[]{-1, -1};
            this._opInProgress = false;
            this._operationLabel = RecorderMessages.abstractRecorderManager_unknownOperation_Lbl;
        }

        public boolean isValid() {
            return this._isValid;
        }

        public int getStartingOperation() {
            return this._doublet[0];
        }

        public int getClosingOperation() {
            return this._doublet[1];
        }

        public void setToKo() {
            this._doublet[1] = 7;
        }

        public String getLabel() {
            return this._operationLabel;
        }

        public Date getDate() {
            return this._date;
        }

        public void setDate(Date date) {
            this._date = date;
        }

        public void setLabel(String label) {
            this._operationLabel = label;
        }

        public boolean isOperationInProgress() {
            return this._opInProgress;
        }

        public void operationStarted(int startEvent) {
            if (-1 == startEvent) {
                this.init();
            } else {
                int expectedFinishOperation = -1;
                try {
                    expectedFinishOperation = RecorderManagerUtils.getExpectedClosingEvent(startEvent);
                }
                catch (RecorderException exception) {
                    this._isValid = false;
                    return;
                }
                this._doublet[0] = startEvent;
                this._doublet[1] = expectedFinishOperation;
            }
            this._isValid = true;
            this._opInProgress = true;
        }
    }
}

