/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.command.recorder.core.recorder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.common.command.recorder.core.manager.AbstractRecorderManager;
import org.polarsys.capella.common.command.recorder.core.recorder.IRecorder;

public abstract class AbstractRecorder
extends ResourceSetListenerImpl
implements IRecorder,
SessionManagerListener {
    protected AbstractRecorderManager _manager;
    protected List<Data> _events;

    public AbstractRecorder(AbstractRecorderManager manager) {
        this._manager = manager;
        this._events = new ArrayList<Data>();
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this._events.add(new Data(new Date(), event.getNotifications()));
        if (this._manager != null) {
            this._manager.recorderChanged(this, event);
        }
    }

    @Override
    public void clearRecords() {
        for (Data data : this._events) {
            data.getNotification().clear();
        }
        this._events.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._events.isEmpty();
    }

    public void notify(Session updatedSession, int notification) {
    }

    public void viewpointDeselected(Viewpoint deselectedViewpoint) {
    }

    public void viewpointSelected(Viewpoint selectedViewpoint) {
    }

    public void notifyAddSession(Session newSession) {
    }

    public void notifyRemoveSession(Session removedSession) {
    }

    public void notifyUpdatedSession(Session updated) {
    }

    public class Data {
        protected Date _date;
        protected List<Notification> _notifications;

        public Data(Date d, List<Notification> notifs) {
            this._date = d;
            this._notifications = new ArrayList<Notification>(notifs);
        }

        public Date getDate() {
            return this._date;
        }

        public List<Notification> getNotification() {
            return this._notifications;
        }
    }
}

