/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.command.recorder.core.writer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.polarsys.capella.common.command.recorder.core.writer.DummyTreeData;
import org.polarsys.capella.common.command.recorder.core.writer.TXTWriterHelper;

public class TXTRecordReader {
    static final String WHITE_STRING = " ";
    protected File _file;
    protected BufferedReader _reader = null;
    protected DummyTreeData _data = null;

    public TXTRecordReader(File file) {
        this._file = file;
    }

    public DummyTreeData getData() {
        return this._data;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse() {
        boolean result = true;
        if (this._file == null) return false;
        if (!this._file.exists()) {
            return false;
        }
        this._data = new DummyTreeData(null, -1);
        try {
            try {
                FileInputStream is = new FileInputStream(this._file);
                this._reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                String line = null;
                DummyTreeData entry = null;
                DummyTreeData parent = null;
                DummyTreeData last = null;
                DummyTreeData current = null;
                while ((line = this._reader.readLine()) != null) {
                    String[] tag;
                    if (line.length() == 0) {
                        return result;
                    }
                    if ((line = line.trim()).startsWith(TXTWriterHelper.ENTRY_TAG)) {
                        current = entry = new DummyTreeData(this._data, -1);
                        current.setData(this.splitEntry(line));
                        last = current;
                        this._data.addChild(entry);
                        continue;
                    }
                    if (line.startsWith(TXTWriterHelper.SUBENTRY_TAG)) {
                        tag = this.splitSubEntry(line);
                        int depth = Integer.valueOf(tag[0]);
                        if (depth == 0) {
                            parent = entry;
                            current = new DummyTreeData(parent, depth);
                            current.setData(tag);
                            last = current;
                            parent.addChild(current);
                            continue;
                        }
                        int lastDepth = last.getDepth();
                        if (depth > lastDepth) {
                            parent = last;
                            current = new DummyTreeData(parent, depth);
                            current.setData(tag);
                            last = current;
                            parent.addChild(current);
                            continue;
                        }
                        parent = last.getParent();
                        int delta = depth - lastDepth;
                        int i = 0;
                        while (i < delta) {
                            parent = parent.getParent();
                            ++i;
                        }
                        current = new DummyTreeData(parent, depth);
                        current.setData(tag);
                        last = current;
                        parent.addChild(current);
                        continue;
                    }
                    if (!line.startsWith(TXTWriterHelper.EXTRADATA_TAG)) continue;
                    tag = null;
                    tag = last.getDepth() == -1 ? this.splitExtraDataForDate(line) : this.splitExtraDataForEObject(line);
                    current.setSubData(tag);
                }
                return result;
            }
            catch (FileNotFoundException exception) {
                result = false;
                if (this._reader == null) return result;
                try {
                    this._reader.close();
                    this._reader = null;
                    return result;
                }
                catch (IOException iOException) {}
                return result;
            }
            catch (UnsupportedEncodingException exception) {
                result = false;
                if (this._reader == null) return result;
                try {
                    this._reader.close();
                    this._reader = null;
                    return result;
                }
                catch (IOException iOException) {}
                return result;
            }
            catch (IOException exception) {
                result = false;
                if (this._reader == null) return result;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    this._reader.close();
                    this._reader = null;
                    return result;
                }
                catch (IOException iOException) {}
                return result;
            }
        }
        finally {
            if (this._reader != null) {
                try {
                    this._reader.close();
                    this._reader = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String[] splitEntry(String line) {
        String tmp2;
        String tmp = this.removePrefix(line, TXTWriterHelper.ENTRY_TAG);
        String tmp1 = tmp.split(WHITE_STRING)[0];
        try {
            tmp2 = tmp.substring(tmp1.length() + 1);
        }
        catch (StringIndexOutOfBoundsException exception) {
            tmp2 = "---";
        }
        return new String[]{tmp1, tmp2};
    }

    protected String[] splitSubEntry(String line) {
        String tmp2;
        String tmp = this.removePrefix(line, TXTWriterHelper.SUBENTRY_TAG);
        String tmp1 = tmp.split(WHITE_STRING)[0];
        String tmp3 = "";
        try {
            tmp2 = tmp.substring(tmp1.length() + 1);
        }
        catch (StringIndexOutOfBoundsException exception) {
            tmp2 = "---";
        }
        if (tmp2.indexOf("id::") > 0) {
            String[] l = tmp2.split("id::");
            tmp2 = l[0];
            tmp3 = l[1];
        }
        return new String[]{tmp1, tmp2, tmp3};
    }

    protected String[] splitExtraDataForDate(String line) {
        String tmp = this.removePrefix(line, TXTWriterHelper.EXTRADATA_TAG);
        return new String[]{tmp};
    }

    protected String[] splitExtraDataForEObject(String line) {
        String tmp = this.removePrefix(line, TXTWriterHelper.EXTRADATA_TAG);
        return tmp.split(WHITE_STRING);
    }

    protected String removePrefix(String line, String prefix) {
        return line.substring(prefix.length() + 1);
    }
}

