/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.common.ui.business.api.views.properties.tabbed.ILabelProviderProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.ui.toolkit.viewers.CapellaElementLabelProvider;

public class TabbedPropertiesLabelProvider
extends CapellaElementLabelProvider
implements ILabelProviderProvider {
    public String getText(Object element) {
        Object selection;
        String title = "<unknown>";
        EObject modelElement = this.getModel(element);
        if (modelElement != null) {
            title = super.getText((Object)modelElement);
            if (title != null) {
                String metaclassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EObject)modelElement, (boolean)true);
                if (metaclassLabel != null && !title.startsWith(metaclassLabel)) {
                    title = String.valueOf(metaclassLabel) + title;
                }
            } else {
                title = EObjectLabelProviderHelper.getText((EObject)modelElement);
            }
        } else if (element instanceof StructuredSelection && (selection = ((IStructuredSelection)element).getFirstElement()) instanceof AbstractGraphicalEditPart) {
            return this.getTextForEditPart((AbstractGraphicalEditPart)selection);
        }
        return this.encode(title);
    }

    private String getTextForEditPart(AbstractGraphicalEditPart editPart) {
        StringBuilder sb = new StringBuilder("");
        Object model = editPart.getModel();
        if (editPart instanceof NoteEditPart) {
            sb.append(((Shape)model).getType());
            return sb.toString();
        }
        if (editPart instanceof TextEditPart) {
            sb.append(((Shape)model).getType());
            return sb.toString();
        }
        if (editPart instanceof NoteAttachmentEditPart) {
            sb.append(((Connector)model).getType());
            return sb.toString();
        }
        return sb.toString();
    }

    protected String encode(String str) {
        return str.replaceAll("&", "&&");
    }

    public Image getImage(Object element) {
        EObject model = this.getModel(element);
        if (model != null) {
            return super.getImage((Object)model);
        }
        return null;
    }

    private EObject getModel(Object element) {
        if (element instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)element;
            return CapellaAdapterHelper.resolveSemanticObject((Object)selection.getFirstElement());
        }
        return null;
    }

    public ILabelProvider getLabelProvider() {
        return this;
    }

    public boolean provides(Object selection) {
        return true;
    }
}

