/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.fields.AbstractStructuredRepresentationField;
import org.polarsys.capella.core.ui.properties.fields.Messages;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.viewers.IDelegatedViewer;
import org.polarsys.capella.core.ui.properties.viewers.TableDelegatedViewer;
import org.polarsys.capella.core.ui.toolkit.actions.move.MoveDownAction;
import org.polarsys.capella.core.ui.toolkit.actions.move.MoveUpAction;

public class ContainmentTableField
extends AbstractStructuredRepresentationField {
    protected EReference _referencerFeature;
    protected EClass _referencedFeatureType;
    protected String _selectionElementDialogMessage;
    private Button _addBtn;
    private Button _upBtn;
    private Button _downBtn;

    public ContainmentTableField(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, EReference referencerFeature, EReference referencedFeature, EClass referencedFeatureType, String label, String selectionElementDialogMessage, IDelegatedViewer viewer) {
        super(parent, widgetFactory, referencedFeature, label, viewer);
        this._referencerFeature = referencerFeature;
        this._referencedFeatureType = referencedFeatureType;
        this._selectionElementDialogMessage = selectionElementDialogMessage;
    }

    public ContainmentTableField(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, EReference referencerFeature, EReference referencedFeature, EClass referencedFeatureType, String label, String selectionElementDialogMessage) {
        this(parent, widgetFactory, referencerFeature, referencedFeature, referencedFeatureType, label, selectionElementDialogMessage, new TableDelegatedViewer(widgetFactory));
    }

    @Override
    protected void createCustomActions(Composite parent) {
        this._downBtn = this.createTableButton(parent, CapellaUIPropertiesPlugin.getDefault().getImage("ArrowDown_16x16.gif"), new Runnable(){

            @Override
            public void run() {
                ContainmentTableField.this.handleDown();
            }
        });
        this._upBtn = this.createTableButton(parent, CapellaUIPropertiesPlugin.getDefault().getImage("ArrowUp_16x16.gif"), new Runnable(){

            @Override
            public void run() {
                ContainmentTableField.this.handleUp();
            }
        });
        this._addBtn = this.createTableButton(parent, CapellaUIPropertiesPlugin.getDefault().getImage("Add_16x16.gif"), new Runnable(){

            @Override
            public void run() {
                ContainmentTableField.this.handleAdd();
            }
        });
    }

    @Override
    protected void handleDelete() {
        ColumnViewer columnViewer;
        if (this._delegatedViewer != null && (columnViewer = this._delegatedViewer.getColumnViewer()) != null) {
            final List selectedReferencedElements = ((IStructuredSelection)columnViewer.getSelection()).toList();
            AbstractReadWriteCommand deleteCommand = new AbstractReadWriteCommand(){

                public String getName() {
                    return Messages.ReferencesTableField_DeleteCommand_Label;
                }

                public void run() {
                    CapellaDeleteCommand command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)ContainmentTableField.this._semanticElement), ContainmentTableField.this.getContainedElementsfor(selectedReferencedElements), true, false, false);
                    if (command.canExecute()) {
                        command.execute();
                    }
                }
            };
            this.executeCommand((ICommand)deleteCommand);
            this.refreshViewer();
        }
    }

    protected void handleAdd() {
        final Collection<? extends EObject> selectedElements = DialogHelper.openMultiSelectionDialog((Control)this._addBtn, this.getAvailableElementsToAdd());
        if (selectedElements != null) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    List containedElements = (List)ContainmentTableField.this._semanticElement.eGet(ContainmentTableField.this._semanticFeature);
                    EFactory eFactoryInstance = ContainmentTableField.this._referencedFeatureType.getEPackage().getEFactoryInstance();
                    for (EObject selectedElement : selectedElements) {
                        EObject createdObjectForSelectedOne = eFactoryInstance.create(ContainmentTableField.this._referencedFeatureType);
                        if (ContainmentTableField.this._referencedFeature != null) {
                            createdObjectForSelectedOne.eSet((EStructuralFeature)ContainmentTableField.this._referencedFeature, (Object)selectedElement);
                        }
                        if (ContainmentTableField.this._referencerFeature != null) {
                            createdObjectForSelectedOne.eSet((EStructuralFeature)ContainmentTableField.this._referencerFeature, (Object)ContainmentTableField.this._semanticElement);
                        }
                        containedElements.add(createdObjectForSelectedOne);
                    }
                }
            };
            TransactionHelper.getExecutionManager((EObject)this._semanticElement).execute((ICommand)command);
            this.refreshViewer();
        }
    }

    protected void handleDown() {
        List selectedReferencedElements = ((IStructuredSelection)this._delegatedViewer.getColumnViewer().getSelection()).toList();
        MoveDownAction action = new MoveDownAction();
        action.updateSelection((IStructuredSelection)new StructuredSelection(this.getContainedElementsfor(selectedReferencedElements)));
        action.run();
        this.refreshViewer();
    }

    protected void handleUp() {
        List selectedReferencedElements = ((IStructuredSelection)this._delegatedViewer.getColumnViewer().getSelection()).toList();
        MoveUpAction action = new MoveUpAction();
        action.updateSelection((IStructuredSelection)new StructuredSelection(this.getContainedElementsfor(selectedReferencedElements)));
        action.run();
        this.refreshViewer();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._downBtn != null && !this._downBtn.isDisposed()) {
            this._downBtn.setEnabled(enabled);
        }
        if (this._upBtn != null && !this._upBtn.isDisposed()) {
            this._upBtn.setEnabled(enabled);
        }
        if (this._addBtn != null && !this._addBtn.isDisposed()) {
            this._addBtn.setEnabled(enabled);
        }
    }

    protected List<? extends EObject> getAvailableElementsToAdd() {
        final ArrayList availableElements = new ArrayList(0);
        AbstractReadOnlyCommand command = new AbstractReadOnlyCommand(){

            public void run() {
                IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(ContainmentTableField.this._semanticElement.eClass(), ContainmentTableField.this._semanticFeature);
                if (query != null) {
                    availableElements.addAll(query.getAvailableElements(ContainmentTableField.this._semanticElement));
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)this._semanticElement).execute((ICommand)command);
        availableElements.removeAll(this.getReferencedElementsByContainedOnes());
        return availableElements;
    }

    protected SelectElementsDialog getSelectionElementDialog(Shell parentShell, TransactionalEditingDomain editingDomain, AdapterFactory adapterFactory, String dialogTitle, String dialogMessage, List<? extends EObject> displayedElements) {
        return new SelectElementsDialog(parentShell, editingDomain, adapterFactory, dialogTitle, dialogMessage, displayedElements, true, null);
    }
}

