/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractStructuredRepresentationField;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.helpers.NamingHelper;
import org.polarsys.capella.core.ui.properties.viewers.IDelegatedViewer;

public class ReferenceTableField
extends AbstractStructuredRepresentationField {
    protected Button _browseBtn;
    protected IMultipleSemanticFieldController _controller;

    public ReferenceTableField(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, EReference referencedFeature, String label, IMultipleSemanticFieldController controller, IDelegatedViewer delegatedViewer) {
        super(parent, widgetFactory, referencedFeature, label, delegatedViewer);
        this._controller = controller;
    }

    @Override
    protected void createCustomActions(Composite parent) {
        this._browseBtn = this.createTableButton(parent, CapellaUIPropertiesPlugin.getDefault().getImage("Browse_16x16.gif"), new Runnable(){

            @Override
            public void run() {
                ReferenceTableField.this.handleBrowse();
            }
        });
    }

    protected void handleBrowse() {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, ReferenceTableField.this._semanticFeature);
                if (query != null) {
                    List<EObject> currentElements = ReferenceTableField.this._controller.readOpenValues(ReferenceTableField.this._semanticElement, ReferenceTableField.this._semanticFeature, false);
                    List<EObject> availableElements = ReferenceTableField.this._controller.readOpenValues(ReferenceTableField.this._semanticElement, ReferenceTableField.this._semanticFeature, true);
                    availableElements.removeAll(currentElements);
                    String title = NamingHelper.getDefaultTitle(ReferenceTableField.this._semanticElement);
                    String message = NamingHelper.getDefaultMessage(ReferenceTableField.this._semanticElement, ReferenceTableField.this._semanticFeature != null ? ReferenceTableField.this._semanticFeature.getName() : "");
                    List<EObject> allResults = DialogHelper.openTransferDialog((Control)ReferenceTableField.this._browseBtn, currentElements, availableElements, title, message);
                    if (allResults != null) {
                        ReferenceTableField.this._controller.writeOpenValues(ReferenceTableField.this._semanticElement, ReferenceTableField.this._semanticFeature, allResults);
                    }
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)this._semanticElement).execute((ICommand)command);
        this.refreshViewer();
    }

    @Override
    protected void handleDelete() {
        List selectedReferencedElements;
        ColumnViewer columnViewer;
        if (this._delegatedViewer != null && (columnViewer = this._delegatedViewer.getColumnViewer()) != null && !(selectedReferencedElements = ((IStructuredSelection)columnViewer.getSelection()).toList()).isEmpty()) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    if (ReferenceTableField.this._semanticFeature instanceof EReference && !((EReference)ReferenceTableField.this._semanticFeature).isContainment()) {
                        if (ReferenceTableField.this._semanticFeature.isMany()) {
                            ((List)ReferenceTableField.this._semanticElement.eGet(ReferenceTableField.this._semanticFeature)).removeAll(selectedReferencedElements);
                        } else {
                            ReferenceTableField.this._semanticElement.eSet(ReferenceTableField.this._semanticFeature, null);
                        }
                    }
                }
            };
            TransactionHelper.getExecutionManager((EObject)this._semanticElement).execute((ICommand)command);
            this.refreshViewer();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._browseBtn != null && !this._browseBtn.isDisposed()) {
            this._browseBtn.setEnabled(enabled);
        }
    }
}

