/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.ui.properties.controllers.RepresentationContextualElementsController;
import org.polarsys.capella.core.ui.properties.fields.BrowseSemanticField;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.helpers.NamingHelper;

public class RepresentationContextualElementsField
extends BrowseSemanticField {
    protected WeakReference<DRepresentation> _representation;
    protected RepresentationContextualElementsController _controller;

    public RepresentationContextualElementsField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, RepresentationContextualElementsController controller) {
        this(parent, label, widgetFactory, 3, controller, false);
    }

    public RepresentationContextualElementsField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, int textFieldSpan, RepresentationContextualElementsController controller, boolean hasAddBtn) {
        super(parent, label, widgetFactory, textFieldSpan);
        this._controller = controller;
        if (hasAddBtn) {
            this.createAddButton(parent);
        }
        this.createOpenButton(parent);
        this.createDeleteButton(parent);
    }

    public void loadData(DRepresentation dRepresentation) {
        this._representation = new WeakReference<DRepresentation>(dRepresentation);
        this.setValueTextField(this._controller.loadValues((EObject)dRepresentation));
    }

    @Override
    protected ExecutionManager getExecutionManager() {
        return TransactionHelper.getExecutionManager((EObject)((EObject)this._representation.get()));
    }

    @Override
    protected void handleOpenButtonClicked(final Button button) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                List<EObject> currentElements = RepresentationContextualElementsField.this._controller.readOpenValues((EObject)RepresentationContextualElementsField.this._representation.get(), false);
                List<EObject> availableElements = RepresentationContextualElementsField.this._controller.readOpenValues((EObject)RepresentationContextualElementsField.this._representation.get(), true);
                availableElements.removeAll(currentElements);
                String title = ((DRepresentation)RepresentationContextualElementsField.this._representation.get()).getName();
                String message = NamingHelper.getDefaultMessage((EObject)RepresentationContextualElementsField.this._representation.get(), "contextual elements");
                List<EObject> allResults = DialogHelper.openTransferDialog((Control)button, currentElements, availableElements, title, message);
                if (allResults != null) {
                    List<EObject> writeOpenValues = RepresentationContextualElementsField.this._controller.writeOpenValues((EObject)RepresentationContextualElementsField.this._representation.get(), allResults);
                    RepresentationContextualElementsField.this.setValueTextField(writeOpenValues);
                }
            }
        };
        this.executeCommand((ICommand)command);
    }

    @Override
    protected void handleDeleteButtonClicked() {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                ArrayList<EObject> allResults = new ArrayList<EObject>();
                if (allResults != null) {
                    List<EObject> writeOpenValues = RepresentationContextualElementsField.this._controller.writeOpenValues((EObject)RepresentationContextualElementsField.this._representation.get(), allResults);
                    RepresentationContextualElementsField.this.setValueTextField(writeOpenValues);
                }
            }
        };
        this.executeCommand((ICommand)command);
    }
}

