/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.sections;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlyListener;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.ui.properties.CapellalEditingDomainListenerForPropertySections;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.sections.IAbstractSection;
import org.polarsys.capella.core.ui.properties.wizards.Messages;

public abstract class AbstractSection
extends AbstractPropertySection
implements IAbstractSection,
IOperationHistoryListener,
IReadOnlyListener {
    private boolean _displayedInWizard;
    private EObject _capellaElement;
    private Color _parentBackgroundColor;
    protected Composite _rootParentComposite;
    private TabbedPropertySheetWidgetFactory _widgetFactory;
    private Group _referencesGroup;
    private Group _checkGroup;
    private TabbedPropertySheetPage _propertySheetPage;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        if (this._parentBackgroundColor != null) {
            this.handleParentBackground(this._parentBackgroundColor, parent);
        }
        if (aTabbedPropertySheetPage == null) {
            this._rootParentComposite = parent;
            this._displayedInWizard = true;
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AbstractSection.this.dispose();
                }
            });
        } else {
            this._propertySheetPage = aTabbedPropertySheetPage;
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
            Section section = this.getWidgetFactory().createSection(parent, 322);
            section.setText(Messages.CapellaElement_SectionLabel);
            this._rootParentComposite = this.getWidgetFactory().createFlatFormComposite((Composite)section);
            this._rootParentComposite.setLayout((Layout)new GridLayout(2, true));
            section.setClient((Control)this._rootParentComposite);
            CapellalEditingDomainListenerForPropertySections.getCapellaDataListenerForPropertySections().registerPropertySheetPage(this._propertySheetPage);
        }
    }

    public void dispose() {
        super.dispose();
        CapellaReadOnlyHelper.unregister((EObject)this._capellaElement, (IReadOnlyListener)this);
        CapellalEditingDomainListenerForPropertySections.getCapellaDataListenerForPropertySections().unregisterPropertySheetPage(this._propertySheetPage);
        this._capellaElement = null;
        if (this._widgetFactory != null) {
            this._widgetFactory.dispose();
            this._widgetFactory = null;
        }
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
    }

    protected Color getColor() {
        return this._parentBackgroundColor;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        TabbedPropertySheetWidgetFactory result = null;
        if (!this.isDisplayedInWizard()) {
            result = super.getWidgetFactory();
        } else {
            if (this._widgetFactory == null) {
                this._widgetFactory = new TabbedPropertySheetWidgetFactory();
            }
            result = this._widgetFactory;
        }
        return result;
    }

    protected Group getReferencesGroup() {
        if (this._referencesGroup == null) {
            this._referencesGroup = this.getWidgetFactory().createGroup(this._rootParentComposite, "");
            this._referencesGroup.setLayout((Layout)new GridLayout(6, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._referencesGroup.setLayoutData((Object)gd);
        }
        return this._referencesGroup;
    }

    protected Group getCheckGroup() {
        if (this._checkGroup == null) {
            this._checkGroup = this.getWidgetFactory().createGroup(this._rootParentComposite, "");
            this._checkGroup.setLayout((Layout)new GridLayout(6, true));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._checkGroup.setLayoutData((Object)gd);
            this._checkGroup.moveAbove((Control)this.getReferencesGroup());
        }
        return this._checkGroup;
    }

    protected void handleParentBackground(Color color, Composite parent) {
        parent.setBackground(color);
    }

    public void historyNotification(OperationHistoryEvent event) {
        Command command;
        IUndoableOperation operation;
        int eventType = event.getEventType();
        if ((10 == eventType || 9 == eventType) && (operation = event.getOperation()) instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()).getAffectedObjects().contains(this._capellaElement)) {
            this.refresh();
        }
    }

    protected boolean isDisplayedInWizard() {
        return this._displayedInWizard;
    }

    @Override
    public void loadData(EObject object) {
        EObject capellaElement = object;
        if (object instanceof DSemanticDecorator) {
            DSemanticDecorator dsem = (DSemanticDecorator)object;
            capellaElement = (CapellaElement)dsem.getTarget();
        }
        if (this._capellaElement == null) {
            OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        }
        this._capellaElement = capellaElement;
        this.register(this._capellaElement);
        IReadOnlySectionHandler roHandler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
        if (roHandler != null && roHandler.isLockedByOthers(this._capellaElement)) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void refresh() {
        if (this._capellaElement != null && this._capellaElement.eResource() != null) {
            this.loadData(this._capellaElement);
        }
    }

    public abstract boolean select(Object var1);

    protected EObject selection(Object toTest) {
        return CapellaAdapterHelper.resolveSemanticObject((Object)toTest);
    }

    protected EObject setInputSelection(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        return CapellaAdapterHelper.resolveSemanticObject((Object)((IStructuredSelection)selection).getFirstElement());
    }

    @Override
    public void setParentBackgroundColor(Color color) {
        this._parentBackgroundColor = color;
    }

    public void setEnabled(boolean enabled) {
        for (AbstractSemanticField semanticField : this.getSemanticFields()) {
            if (semanticField == null) continue;
            semanticField.setEnabled(enabled);
        }
    }

    public void refreshTitleBar() {
        if (this._propertySheetPage != null) {
            try {
                Method refreshTitleMethod = TabbedPropertySheetPage.class.getDeclaredMethod("refreshTitleBar", new Class[0]);
                refreshTitleMethod.setAccessible(true);
                refreshTitleMethod.invoke((Object)this._propertySheetPage, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void executeCommmand(ICommand command) {
        this.getExecutionManager().execute(command);
    }

    protected ExecutionManager getExecutionManager() {
        return TransactionHelper.getExecutionManager((EObject)this._capellaElement);
    }

    public abstract List<AbstractSemanticField> getSemanticFields();

    protected IReadOnlySectionHandler register(EObject element) {
        return CapellaReadOnlyHelper.register((EObject)element, (IReadOnlyListener)this);
    }
}

