/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.BooleanValueGroup;
import org.polarsys.capella.core.ui.properties.fields.EnumerationValueGroup;
import org.polarsys.capella.core.ui.properties.fields.TextAreaValueGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.core.ui.properties.sections.Messages;

public class CapellaManagementPropertySection
extends AbstractSection
implements IFilter {
    private BooleanValueGroup _visibleInDocGroup;
    private BooleanValueGroup _visibleInLMGroup;
    private EnumerationValueGroup _status;
    private TextAreaValueGroup _review;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this._rootParentComposite.setLayout((Layout)new GridLayout());
        this._rootParentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean displayedInWizard = this.isDisplayedInWizard();
        this._visibleInDocGroup = new BooleanValueGroup(this._rootParentComposite, Messages.VisibleInDocGroup_Label, this.getWidgetFactory());
        this._visibleInDocGroup.setDisplayedInWizard(displayedInWizard);
        this._visibleInLMGroup = new BooleanValueGroup(this._rootParentComposite, Messages.VisibleForTraceabilityGroup_Label, this.getWidgetFactory());
        this._visibleInLMGroup.setDisplayedInWizard(displayedInWizard);
        this._status = new EnumerationValueGroup(this._rootParentComposite, Messages.ProgressStatus_Label, this.getWidgetFactory());
        this._status.setDisplayedInWizard(displayedInWizard);
        this._review = new TextAreaValueGroup(this._status.getParent(), Messages.ReviewGroup_Label, this.getWidgetFactory(), true);
        this._review.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this._visibleInDocGroup.loadData(capellaElement, (EStructuralFeature)ModellingcorePackage.eINSTANCE.getPublishableElement_VisibleInDoc());
        this._visibleInLMGroup.loadData(capellaElement, (EStructuralFeature)ModellingcorePackage.eINSTANCE.getPublishableElement_VisibleInLM());
        this._status.loadData(capellaElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getCapellaElement_Status());
        this._review.loadData(capellaElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getCapellaElement_Review());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject selectedElt;
        if (selection instanceof StructuredSelection && (selectedElt = CapellaAdapterHelper.resolveSemanticObject((Object)((StructuredSelection)selection).getFirstElement())) instanceof CapellaElement) {
            AbstractType type;
            boolean allowMultiplePart;
            if (selectedElt.eClass().equals(CsPackage.eINSTANCE.getPart()) && !(allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((Part)selectedElt)))) && (type = ((Part)selectedElt).getAbstractType()) != null && !(type instanceof ConfigurationItem)) {
                super.setInput(part, (ISelection)new StructuredSelection((Object)type));
                this.loadData((EObject)((CapellaElement)type));
                return;
            }
            this.loadData((EObject)((CapellaElement)selectedElt));
        }
        super.setInput(part, selection);
    }

    @Override
    public boolean select(Object toTest) {
        EObject eObj = CapellaAdapterHelper.resolveSemanticObject((Object)toTest);
        return eObj instanceof CapellaElement;
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.add(this._visibleInDocGroup);
        fields.add(this._visibleInLMGroup);
        fields.add(this._status);
        fields.add(this._review);
        return fields;
    }
}

