/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.sections;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.ui.properties.annotations.RepresentationAnnotationHelper;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.BooleanValueGroup;
import org.polarsys.capella.core.ui.properties.fields.EnumerationValueGroup;
import org.polarsys.capella.core.ui.properties.fields.TextAreaValueGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.core.ui.properties.sections.Messages;

public class DiagramManagementPropertySection
extends AbstractSection {
    private WeakReference<DRepresentation> _representation;
    private BooleanValueGroup _visibleInDocGroup;
    private BooleanValueGroup _visibleInLMGroup;
    private EnumerationValueGroup _status;
    private TextAreaValueGroup _review;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this._rootParentComposite.setLayout((Layout)new GridLayout());
        this._rootParentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean displayedInWizard = this.isDisplayedInWizard();
        this._visibleInDocGroup = new BooleanValueGroup(this._rootParentComposite, Messages.VisibleInDocGroup_Label, this.getWidgetFactory()){

            @Override
            public void loadComboValue() {
                this._valueField.select(RepresentationAnnotationHelper.isVisibleInDoc((DRepresentation)DiagramManagementPropertySection.this._representation.get()) ? 0 : 1);
            }

            @Override
            protected void fillComboField(CCombo comboField) {
                if (comboField.equals(this._valueField)) {
                    DiagramManagementPropertySection.this.updateAnnotation("http://www.polarsys.org/capella/core/NotVisibleInDoc", Boolean.valueOf(this._comboItems[this._valueField.getSelectionIndex()]));
                }
            }
        };
        this._visibleInDocGroup.setDisplayedInWizard(displayedInWizard);
        this._visibleInLMGroup = new BooleanValueGroup(this._rootParentComposite, Messages.VisibleForTraceabilityGroup_Label, this.getWidgetFactory()){

            @Override
            public void loadComboValue() {
                this._valueField.select(RepresentationAnnotationHelper.isVisibleInLM((DRepresentation)DiagramManagementPropertySection.this._representation.get()) ? 0 : 1);
            }

            @Override
            protected void fillComboField(CCombo comboField) {
                if (comboField.equals(this._valueField)) {
                    DiagramManagementPropertySection.this.updateAnnotation("http://www.polarsys.org/capella/core/NotVisibleInLM", Boolean.valueOf(this._comboItems[this._valueField.getSelectionIndex()]));
                }
            }
        };
        this._visibleInLMGroup.setDisplayedInWizard(displayedInWizard);
        this._status = new EnumerationValueGroup(this._rootParentComposite, Messages.ProgressStatus_Label, this.getWidgetFactory()){

            @Override
            protected void setDataValue(EObject object, EStructuralFeature feature, Object value) {
                String val = "";
                if (value instanceof AbstractNamedElement) {
                    val = ((AbstractNamedElement)value).getName();
                }
                DiagramManagementPropertySection.this.updateAnnotation("http://www.polarsys.org/capella/core/ProgressStatus", "value", val);
            }

            @Override
            protected List<EObject> getAvailableValues() {
                ArrayList<EObject> result = new ArrayList<EObject>(0);
                IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, (EStructuralFeature)CapellacorePackage.Literals.CAPELLA_ELEMENT__STATUS);
                if (query != null) {
                    result.addAll(query.getAvailableElements((EObject)((CapellaElement)CapellaAdapterHelper.resolveSemanticObject(DiagramManagementPropertySection.this._representation.get(), (boolean)true))));
                }
                return result;
            }

            @Override
            protected List<EObject> getCurrentValues() {
                ArrayList<EObject> result = new ArrayList<EObject>(0);
                String value = RepresentationAnnotationHelper.getProgressStatus((DRepresentation)DiagramManagementPropertySection.this._representation.get());
                if (value != null) {
                    for (EObject element : this.getAvailableValues()) {
                        if (!value.equals(((AbstractNamedElement)element).getName())) continue;
                        result.add(element);
                    }
                }
                return result;
            }
        };
        this._status.setDisplayedInWizard(displayedInWizard);
        this._review = new TextAreaValueGroup(this._status.getParent(), Messages.ReviewGroup_Label, this.getWidgetFactory(), true){

            @Override
            public void loadTextValue() {
                this._valueField.setText(RepresentationAnnotationHelper.getStatusReview((DRepresentation)DiagramManagementPropertySection.this._representation.get()));
            }

            @Override
            protected void setDataValue(EObject object, EStructuralFeature feature, Object value) {
                String val = "";
                if (value instanceof String) {
                    val = (String)value;
                }
                DiagramManagementPropertySection.this.updateAnnotation("http://www.polarsys.org/capella/core/StatusReview", "value", val);
            }
        };
        this._review.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._representation != null) {
            this._representation.clear();
            this._representation = null;
        }
    }

    protected void updateAnnotation(final String source, final Boolean value) {
        this.executeCommmand((ICommand)new AbstractReadWriteCommand(){

            public Collection<?> getAffectedObjects() {
                return Collections.singleton((DRepresentation)DiagramManagementPropertySection.this._representation.get());
            }

            public String getName() {
                return Messages.RepresentationSection_Command_Representation_Publication_Label;
            }

            public void run() {
                RepresentationAnnotationHelper.setAnnotation((DRepresentation)DiagramManagementPropertySection.this._representation.get(), source, value);
            }
        });
    }

    protected void updateAnnotation(final String source, final String key, final String value) {
        this.executeCommmand((ICommand)new AbstractReadWriteCommand(){

            public Collection<?> getAffectedObjects() {
                return Collections.singleton((DRepresentation)DiagramManagementPropertySection.this._representation.get());
            }

            public String getName() {
                return Messages.RepresentationSection_Command_Representation_Publication_Label;
            }

            public void run() {
                RepresentationAnnotationHelper.setAnnotation((DRepresentation)DiagramManagementPropertySection.this._representation.get(), source, key, value);
            }
        });
    }

    protected void loadData() {
        super.loadData((EObject)this._representation.get());
        this._visibleInDocGroup.loadComboValue();
        this._visibleInLMGroup.loadComboValue();
        this._status.loadComboValue();
        this._review.loadTextValue();
    }

    @Override
    public void refresh() {
        this.loadData();
    }

    @Override
    public boolean select(Object toTest) {
        return toTest instanceof DRepresentationDescriptor || toTest instanceof DRepresentation || toTest instanceof IDDiagramEditPart;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (!selection.isEmpty()) {
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof DRepresentationDescriptor) {
                    firstElement = ((DRepresentationDescriptor)firstElement).getRepresentation();
                }
                if (firstElement instanceof DRepresentation) {
                    this._representation = new WeakReference<DRepresentation>((DRepresentation)firstElement);
                } else if (firstElement instanceof IDDiagramEditPart) {
                    IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)firstElement;
                    this._representation = new WeakReference<DRepresentation>((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement());
                } else {
                    this._representation = null;
                }
            }
            this.loadData();
        }
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.add(this._visibleInDocGroup);
        fields.add(this._visibleInLMGroup);
        fields.add(this._status);
        fields.add(this._review);
        return fields;
    }
}

