/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.epbs.validation.configurationItem;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_ConfigurationItem_PhysicalComponentRealization
extends AbstractValidationRule {
    private static final String NULL = "null";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ConfigurationItem) {
            ConfigurationItem confItem = (ConfigurationItem)eObj;
            EList ownedPhysicalComponentRealisations = confItem.getOwnedPhysicalArtifactRealizations();
            for (PhysicalArtifactRealization next : ownedPhysicalComponentRealisations) {
                TraceableElement allocatedComponent = next.getTargetElement();
                String allocatedComponentName = NULL;
                String allocatedComponentEclass = NULL;
                if (allocatedComponent instanceof AbstractNamedElement) {
                    allocatedComponentName = ((AbstractNamedElement)allocatedComponent).getName();
                    allocatedComponentEclass = allocatedComponent.eClass().getName();
                }
                if (allocatedComponent != null && (allocatedComponent instanceof PhysicalComponent || allocatedComponent instanceof PhysicalLink || allocatedComponent instanceof PhysicalPort)) continue;
                return ctx.createFailureStatus(new Object[]{confItem.getName(), allocatedComponentName, allocatedComponentEclass});
            }
        }
        return ctx.createSuccessStatus();
    }
}

