/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.DynamicCreateChildAction;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractViewerDialog;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.DeleteElementAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.MakeLinkAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.RemoveElementAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.SelectInProjectExplorerAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.SelectInSemanticBrowserAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.StartLinkAction;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationContentProvider;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationDragListener;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationDropAdapter;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationLabelProvider;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationModelHelpers;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationTreeViewer;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationTreeViewerCellModifier;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.LinkManager;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class EIAllocationTransfertDlg
extends AbstractViewerDialog {
    protected Text _statusBarText;
    protected LinkManager _linkManager = new LinkManager();
    protected EIAllocationTreeViewer _sepViewer;
    protected EIAllocationTreeViewer _tepViewer;
    protected List<ModelElement> _selectedElements;
    protected List<ModelElement> _transitionedElements;
    private static final String MSG_PATTERN = "[%s][%s] %s";
    private static final String PATH_SEPARATOR = "::";
    private boolean isAlreadyUpdatingSelection = false;

    public EIAllocationTransfertDlg(Shell parentShell_p, String dialogTitle_p, String dialogMessage_p, String shellTitle_p) {
        super(parentShell_p, dialogTitle_p, dialogMessage_p, shellTitle_p);
    }

    protected void doCreateDialogArea(Composite dialogAreaComposite_p) {
        Composite treeComposite = new Composite(dialogAreaComposite_p, 0x1000000);
        treeComposite.setLayout((Layout)new FillLayout(256));
        GridData gdData = new GridData(1808);
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = true;
        gdData.heightHint = 400;
        gdData.widthHint = 600;
        treeComposite.setLayoutData((Object)gdData);
        this._sepViewer = new EIAllocationTreeViewer(treeComposite);
        this._tepViewer = new EIAllocationTreeViewer(treeComposite);
        this._sepViewer.setGroupLabel("Source Engineering Phase" + this.getArchitectureName(this._selectedElements));
        this._sepViewer.getTreeViewer().setContentProvider((IContentProvider)new EIAllocationContentProvider());
        this._sepViewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)new EIAllocationLabelProvider(this._linkManager, this._sepViewer, true));
        this._sepViewer.getTreeViewer().setColumnProperties(new String[]{ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.getName()});
        this._sepViewer.getTreeViewer().setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this._sepViewer.getTreeViewer().getTree(), 2048)});
        this._sepViewer.getTreeViewer().setCellModifier((ICellModifier)new EIAllocationTreeViewerCellModifier(this._sepViewer.getTreeViewer().getTree()));
        this._sepViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                EIAllocationTransfertDlg.this.updateSelection((ITreeSelection)event_p.getSelection(), false, EIAllocationTransfertDlg.this._tepViewer, EIAllocationTransfertDlg.this._sepViewer);
            }
        });
        this._sepViewer.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event_p) {
                EIAllocationTransfertDlg.this.handleDbClick(event_p, EIAllocationTransfertDlg.this._sepViewer.getTreeViewer());
            }
        });
        this._sepViewer.getTreeViewer().getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                EIAllocationTransfertDlg.this.handleNotification(event, EIAllocationTransfertDlg.this._sepViewer);
            }
        });
        this._sepViewer.setInput(this._selectedElements);
        this._tepViewer.setGroupLabel("Target Engineering Phase" + this.getArchitectureName(this._transitionedElements));
        this._tepViewer.getTreeViewer().setUseHashlookup(true);
        this._tepViewer.getTreeViewer().setContentProvider((IContentProvider)new EIAllocationContentProvider());
        this._tepViewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)new EIAllocationLabelProvider(this._linkManager, this._tepViewer, false));
        this._tepViewer.getTreeViewer().setColumnProperties(new String[]{ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.getName()});
        this._tepViewer.getTreeViewer().setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this._tepViewer.getTreeViewer().getTree(), 2048)});
        this._tepViewer.getTreeViewer().setCellModifier((ICellModifier)new EIAllocationTreeViewerCellModifier(this._tepViewer.getTreeViewer().getTree()));
        this._tepViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                EIAllocationTransfertDlg.this.updateSelection((ITreeSelection)event_p.getSelection(), true, EIAllocationTransfertDlg.this._sepViewer, EIAllocationTransfertDlg.this._tepViewer);
            }
        });
        this._tepViewer.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event_p) {
                EIAllocationTransfertDlg.this.handleDbClick(event_p, EIAllocationTransfertDlg.this._tepViewer.getTreeViewer());
            }
        });
        this._tepViewer.getTreeViewer().getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                EIAllocationTransfertDlg.this.handleNotification(event, EIAllocationTransfertDlg.this._tepViewer);
            }
        });
        this._tepViewer.setInput(this._transitionedElements);
        this.createStatusTextField(dialogAreaComposite_p);
        this.createDragDropSourceTargets();
    }

    protected void handleDbClick(DoubleClickEvent event_p, TreeViewer treeViewer_p) {
        ITreeSelection selection = (ITreeSelection)event_p.getSelection();
        if (!selection.isEmpty()) {
            Object data = selection.getFirstElement();
            ((EIAllocationTreeViewerCellModifier)treeViewer_p.getCellModifier()).setEnabled(true);
            treeViewer_p.editElement(data, 0);
        }
    }

    protected void handleNotification(Event event_p, EIAllocationTreeViewer treeViewer_p) {
        ((EIAllocationTreeViewerCellModifier)treeViewer_p.getTreeViewer().getCellModifier()).setEnabled(false);
        if ("renamed_notification".equals(event_p.text)) {
            this.refreshViewers(true);
            this.updateStatusBar(event_p.data, treeViewer_p);
        }
    }

    protected void updateSelection(ITreeSelection selection, boolean isTEP_p, EIAllocationTreeViewer updatedViewer_p, EIAllocationTreeViewer menuViewer_p) {
        if (!this.isAlreadyUpdatingSelection) {
            this.isAlreadyUpdatingSelection = true;
            if (selection.size() == 1) {
                ModelElement selectedElement = (ModelElement)selection.getFirstElement();
                if (selectedElement instanceof ExchangeItem) {
                    this.selectExchangeItem((ExchangeItem)selectedElement, updatedViewer_p);
                } else {
                    List<ModelElement> elts = isTEP_p ? EIAllocationModelHelpers.getTransitionerElements(selectedElement) : EIAllocationModelHelpers.getTransitionedElements(selectedElement);
                    updatedViewer_p.getTreeViewer().setSelection((ISelection)new StructuredSelection(elts), true);
                }
                this.updateStatusBar((Object)selectedElement, menuViewer_p);
            } else {
                updatedViewer_p.getTreeViewer().setSelection(null, true);
                this.updateStatusBar(null);
            }
            this.showContextualMenu((IStructuredSelection)selection, menuViewer_p.getTreeViewer(), isTEP_p);
            this.isAlreadyUpdatingSelection = false;
        }
    }

    protected String getArchitectureName(List<ModelElement> elements_p) {
        if (!elements_p.isEmpty()) {
            ModelElement elt = elements_p.get(0);
            BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)elt);
            if (OaPackage.Literals.OPERATIONAL_ANALYSIS.equals(arch.eClass())) {
                return " [OA]";
            }
            if (CtxPackage.Literals.SYSTEM_ANALYSIS.equals(arch.eClass())) {
                return " [SA]";
            }
            if (LaPackage.Literals.LOGICAL_ARCHITECTURE.equals(arch.eClass())) {
                return " [LA]";
            }
            if (PaPackage.Literals.PHYSICAL_ARCHITECTURE.equals(arch.eClass())) {
                return " [PA]";
            }
            if (EpbsPackage.Literals.EPBS_ARCHITECTURE.equals(arch.eClass())) {
                return " [EPBS]";
            }
        }
        return "";
    }

    protected void selectExchangeItem(ExchangeItem exchangeItem_p, EIAllocationTreeViewer treeViewer_p) {
        for (EObject obj : EIAllocationModelHelpers.getOwners(exchangeItem_p)) {
            treeViewer_p.getTreeViewer().expandToLevel((Object)obj, 1);
        }
        Widget[] widgets = treeViewer_p.findItems(exchangeItem_p);
        TreeItem[] items = new TreeItem[widgets.length];
        int i = 0;
        while (i < widgets.length) {
            items[i] = (TreeItem)widgets[i];
            ++i;
        }
        treeViewer_p.getTreeViewer().getTree().setSelection(items);
    }

    protected void showContextualMenu(IStructuredSelection selection_p, TreeViewer treeViewer_p, final boolean isTEP_p) {
        MenuManager menuMgr = new MenuManager();
        if (isTEP_p && selection_p.size() == 1) {
            for (Action action : this.getAddElementActions(selection_p, treeViewer_p)) {
                menuMgr.add((IAction)action);
            }
            menuMgr.add((IContributionItem)new Separator());
        }
        menuMgr.add((IAction)new DeleteElementAction(selection_p, treeViewer_p){

            @Override
            protected void postRun() {
                EIAllocationTransfertDlg.this.refreshViewers(isTEP_p);
            }
        });
        menuMgr.add((IAction)new RemoveElementAction(selection_p, treeViewer_p){

            @Override
            protected void postRun() {
                EIAllocationTransfertDlg.this.refreshViewers(isTEP_p);
            }
        });
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new SelectInProjectExplorerAction((ISelection)selection_p));
        menuMgr.add((IAction)new SelectInSemanticBrowserAction((ISelection)selection_p));
        menuMgr.add((IContributionItem)new Separator());
        if (isTEP_p) {
            menuMgr.add((IAction)new StartLinkAction(this._linkManager, treeViewer_p){

                @Override
                protected void postRun() {
                    EIAllocationTransfertDlg.this.refreshViewers(true);
                }
            });
        } else {
            menuMgr.add((IAction)new MakeLinkAction(this._linkManager, treeViewer_p){

                @Override
                protected void postRun() {
                    EIAllocationTransfertDlg.this.refreshViewers(true);
                }
            });
        }
        Menu menu = menuMgr.createContextMenu(treeViewer_p.getControl());
        treeViewer_p.getControl().setMenu(menu);
    }

    protected void refreshViewers(boolean isTEP_p) {
        this._sepViewer.getTreeViewer().refresh(true);
        if (isTEP_p) {
            this._tepViewer.getTreeViewer().refresh(true);
        }
    }

    protected List<Action> getAddElementActions(IStructuredSelection selection, final TreeViewer treeViewer_p) {
        ArrayList<Action> actions = new ArrayList<Action>();
        final Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof AbstractFunction) {
            TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)((EObject)selectedElement));
            for (final CommandParameter cmd : editingDomain.getNewChildDescriptors(selectedElement, null)) {
                final EReference ref = cmd.getEReference();
                final EObject value = cmd.getEValue();
                if (!FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTIONS.equals(ref) && !ActivityPackage.Literals.ABSTRACT_ACTION__INPUTS.equals(ref) && !ActivityPackage.Literals.ABSTRACT_ACTION__OUTPUTS.equals(ref)) continue;
                actions.add((Action)new DynamicCreateChildAction((EditingDomain)editingDomain, (ISelection)selection, cmd){

                    public void run() {
                        EPackage pkg = value.eClass().getEPackage();
                        EFactory factory = pkg.getEFactoryInstance();
                        EObject obj = factory.create(value.eClass());
                        ((Collection)((EObject)selectedElement).eGet((EStructuralFeature)ref)).add(obj);
                        String name = EcoreUtil2.getUniqueName((EObject)obj, (EObject)((EObject)selectedElement), (EStructuralFeature)ref, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)obj.eClass().getName());
                        obj.eSet((EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)name);
                        treeViewer_p.refresh(true);
                    }

                    public String getText() {
                        ItemProviderAdapter itemProvider = (ItemProviderAdapter)((AdapterFactoryEditingDomain)this.editingDomain).getAdapterFactory().adapt((Notifier)cmd.getEValue(), IItemLabelProvider.class);
                        String metaclassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EClass)cmd.getEValue().eClass(), (ItemProviderAdapter)itemProvider);
                        itemProvider.dispose();
                        return metaclassLabel;
                    }
                });
            }
        }
        return actions;
    }

    protected void createDragDropSourceTargets() {
        int operations = 2;
        Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance()};
        this._sepViewer.getTreeViewer().addDragSupport(operations, transferTypes, (DragSourceListener)new EIAllocationDragListener(this._sepViewer.getTreeViewer()));
        this._tepViewer.getTreeViewer().addDropSupport(operations, transferTypes, (DropTargetListener)new EIAllocationDropAdapter(this._sepViewer.getTreeViewer(), this._tepViewer.getTreeViewer()));
    }

    private void createStatusTextField(Composite parent_p) {
        this._statusBarText = new Text(parent_p, 2056);
        this._statusBarText.setEditable(false);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = false;
        gdData.horizontalSpan = 2;
        this._statusBarText.setLayoutData((Object)gdData);
    }

    public void setSelection(List<ModelElement> selectedElements_p, List<ModelElement> transitionedElements_p) {
        this._selectedElements = selectedElements_p;
        this._transitionedElements = transitionedElements_p;
    }

    public Object getResult() {
        return null;
    }

    protected void updateStatusBar(Object element_p) {
        this.updateStatusBar(element_p, Collections.EMPTY_LIST);
    }

    protected void updateStatusBar(Object element_p, EIAllocationTreeViewer treeViewer_p) {
        this.updateStatusBar(element_p, treeViewer_p.findItem(element_p));
    }

    protected void updateStatusBar(Object element_p, Widget widget_p) {
        Object data;
        ArrayList<String> messages = new ArrayList<String>();
        if (widget_p != null && (data = widget_p.getData("Validation")) instanceof IStatus) {
            IStatus status = (IStatus)data;
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    messages.add(String.format(MSG_PATTERN, this.getSeverity(child), this.getRuleId(child), child.getMessage()));
                    ++n2;
                }
            } else {
                messages.add(String.format(MSG_PATTERN, this.getSeverity(status), this.getRuleId(status), status.getMessage()));
            }
        }
        this.updateStatusBar(element_p, messages);
    }

    private String getRuleId(IStatus status_p) {
        if (status_p instanceof ConstraintStatus) {
            IConstraintDescriptor desc = ((ConstraintStatus)status_p).getConstraint().getDescriptor();
            return desc.getId().replace(String.valueOf(desc.getPluginId()) + ".", "");
        }
        return "";
    }

    private String getSeverity(IStatus status_p) {
        switch (status_p.getSeverity()) {
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
        }
        return "";
    }

    protected void updateStatusBar(Object element_p, List<String> messages_p) {
        if (element_p instanceof AbstractNamedElement) {
            AbstractNamedElement element = (AbstractNamedElement)element_p;
            SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
            String path = this.getPath(systemEngineering, element);
            this._statusBarText.setText("[" + messages_p.size() + " warning/error(s)] " + (path == null ? "" : path));
            if (messages_p.size() > 0) {
                String tooltip = "";
                int i = 0;
                while (i < messages_p.size()) {
                    tooltip = String.valueOf(tooltip) + messages_p.get(i);
                    if (i < messages_p.size() - 1) {
                        tooltip = String.valueOf(tooltip) + "\n";
                    }
                    ++i;
                }
                this._statusBarText.setToolTipText(tooltip);
            } else {
                this._statusBarText.setToolTipText(null);
            }
        } else {
            this._statusBarText.setText("");
            this._statusBarText.setToolTipText(null);
        }
    }

    public String getPath(SystemEngineering sysEng_p, AbstractNamedElement target_p) {
        String name;
        String string = name = target_p instanceof ExchangeItemAllocation ? ((ExchangeItemAllocation)target_p).getAllocatedItem().getName() : target_p.getName();
        if (name == null) {
            name = "";
        }
        StringBuffer path = new StringBuffer(name);
        EObject container = target_p.eContainer();
        if (container instanceof AbstractNamedElement) {
            AbstractNamedElement parent = (AbstractNamedElement)target_p.eContainer();
            if (parent != sysEng_p) {
                path.insert(path.indexOf(path.toString()), String.valueOf(this.getPath(sysEng_p, parent)) + PATH_SEPARATOR);
            } else {
                path.insert(path.indexOf(path.toString()), String.valueOf(parent.getName()) + PATH_SEPARATOR);
            }
        }
        return path.toString();
    }
}

