/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;

public class EIAllocationTreeViewerCellModifier
implements ICellModifier {
    public static final String RENAMED_NOTIFICATION = "renamed_notification";
    private boolean _enabled = false;
    private Tree _tree;

    public EIAllocationTreeViewerCellModifier(Tree tree_p) {
        this._tree = tree_p;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled_p) {
        this._enabled = enabled_p;
    }

    public boolean canModify(Object element_p, String property_p) {
        return this.isEnabled();
    }

    public Object getValue(Object element_p, String property_p) {
        if (element_p instanceof AbstractNamedElement) {
            return ((AbstractNamedElement)element_p).getName();
        }
        return null;
    }

    public void modify(Object element_p, String property_p, Object value_p) {
        Object data;
        if (element_p instanceof TreeItem && (data = ((TreeItem)element_p).getData()) instanceof AbstractNamedElement) {
            String newName = value_p.toString();
            this.rename((AbstractNamedElement)data, newName);
            this.sendNotification((TreeItem)element_p, data);
        }
    }

    public void rename(AbstractNamedElement element_p, String name_p) {
        if (!element_p.getName().equals(name_p)) {
            element_p.setName(name_p);
        }
    }

    public void sendNotification(TreeItem item_p, Object data) {
        Event event = new Event();
        event.item = item_p;
        event.data = data;
        event.text = RENAMED_NOTIFICATION;
        this._tree.notifyListeners(3, event);
    }
}

