/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ta.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.capella.extension.genchain.CapellaGenerationExtension;
import org.polarsys.kitalpha.ad.ta.extension.ITargetApplication;
import org.polarsys.kitalpha.ad.ta.extension.TargetApplicationAdapter;
import org.polarsys.kitalpha.doc.gen.business.ecore.genchain.extension.KitalphaDocumentationExtension;

public class CapellaTargetApplication
extends TargetApplicationAdapter {
    public static CapellaTargetApplication INSTANCE = new CapellaTargetApplication();
    private static final String CAPELLA_CORE_RESOURCE = "platform:/plugin/org.polarsys.capella.core.data.gen/model/CapellaCore.ecore";
    private List<EClass> basicSemanticElement = null;

    public CapellaTargetApplication() {
        this.loadSemanticResource();
    }

    public ITargetApplication getInstance() {
        return INSTANCE;
    }

    public List<EClass> getBasicSemanticElement() {
        if (this.basicSemanticElement != null && !this.basicSemanticElement.isEmpty()) {
            return this.basicSemanticElement;
        }
        return Collections.emptyList();
    }

    public List<ExtensionHelper> getGenerationExtensionHelpers() {
        ArrayList<ExtensionHelper> result = new ArrayList<ExtensionHelper>();
        result.add((ExtensionHelper)new CapellaGenerationExtension());
        result.add((ExtensionHelper)new KitalphaDocumentationExtension());
        return result;
    }

    private void loadSemanticResource() {
        ResourceSetImpl set = new ResourceSetImpl();
        URI uri = URI.createURI((String)CAPELLA_CORE_RESOURCE);
        Resource capellaCoreResource = set.getResource(uri, true);
        if (capellaCoreResource == null || capellaCoreResource.getContents().isEmpty()) {
            throw new RuntimeException("Capella Target Applciation Core Resourse is not loaded");
        }
        ArrayList<EClass> result = new ArrayList<EClass>();
        EPackage capellaCorePkg = (EPackage)capellaCoreResource.getContents().get(0);
        result.add((EClass)capellaCorePkg.getEClassifier("NamedElement"));
        this.basicSemanticElement = result;
    }
}

