/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.EngineeringDomain;
import org.polarsys.capella.core.model.skeleton.ISkeletonServices;
import org.polarsys.capella.core.model.skeleton.Messages;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateCtxArchiCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateEPBSArchiCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateEngSystemCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateLogicalArchiCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateOpAnalysisCmd;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreatePhysicalArchiCmd;

public class SkeletonServicesImpl
implements ISkeletonServices {
    private CreateOpAnalysisCmd _currentOpAnalysisCmd;
    private CreateCtxArchiCmd _currentCtxArchitectureCmd;
    private CreateLogicalArchiCmd _currentLogicalArchitectureCmd;
    private CreatePhysicalArchiCmd _currentPhysicalArchitectureCmd;
    private CreateEPBSArchiCmd _currentEpbsArchitectureCmd;

    @Override
    public SystemEngineering doSystemEngineering(final Project project_p, final String systemName_p, final EngineeringDomain engDomain_p, final boolean isOpAnalysisRequired_p) {
        final SystemEngineering[] systemEng = new SystemEngineering[1];
        AbstractReadWriteCommand createSystemEngineeringCommand = new AbstractReadWriteCommand(){

            public void run() {
                CreateEngSystemCmd engSystemCmd = new CreateEngSystemCmd(project_p, systemName_p);
                engSystemCmd.run();
                systemEng[0] = engSystemCmd.getSystemEngineering();
                OperationalAnalysis opAnalysis = null;
                if (isOpAnalysisRequired_p) {
                    SkeletonServicesImpl.this._currentOpAnalysisCmd = new CreateOpAnalysisCmd(systemEng[0], NamingConstants.SkeletonServicesImpl_package_name_operationalAnalysis);
                    SkeletonServicesImpl.this._currentOpAnalysisCmd.run();
                    opAnalysis = SkeletonServicesImpl.this._currentOpAnalysisCmd.getOperationalAnalysis();
                }
                OperationalActivity opActivity = null;
                if (SkeletonServicesImpl.this._currentOpAnalysisCmd != null) {
                    opActivity = SkeletonServicesImpl.this._currentOpAnalysisCmd.getRootOperationalActivity();
                }
                SkeletonServicesImpl.this._currentCtxArchitectureCmd = new CreateCtxArchiCmd(systemEng[0], NamingConstants.SkeletonServicesImpl_package_name_systemAnalysis, opAnalysis, opActivity);
                SkeletonServicesImpl.this._currentCtxArchitectureCmd.run();
                SystemAnalysis contextArchitecture = SkeletonServicesImpl.this._currentCtxArchitectureCmd.getSystemAnalysis();
                SystemFunction systemFunction = null;
                System system = null;
                if (SkeletonServicesImpl.this._currentCtxArchitectureCmd != null) {
                    systemFunction = SkeletonServicesImpl.this._currentCtxArchitectureCmd.getSystemFunction();
                    system = SkeletonServicesImpl.this._currentCtxArchitectureCmd.getSystem();
                }
                SkeletonServicesImpl.this._currentLogicalArchitectureCmd = new CreateLogicalArchiCmd(systemEng[0], NamingConstants.SkeletonServicesImpl_package_name_logicalArchitecture, contextArchitecture, systemFunction, system);
                SkeletonServicesImpl.this._currentLogicalArchitectureCmd.run();
                LogicalArchitecture logicalArchitecture = SkeletonServicesImpl.this._currentLogicalArchitectureCmd.getLogicalArchitecture();
                LogicalComponent logicalComponent = null;
                LogicalFunction logicalFunction = null;
                if (SkeletonServicesImpl.this._currentLogicalArchitectureCmd != null) {
                    logicalComponent = SkeletonServicesImpl.this._currentLogicalArchitectureCmd.getLogicalComponent();
                    logicalFunction = SkeletonServicesImpl.this._currentLogicalArchitectureCmd.getLogicalFunction();
                }
                SkeletonServicesImpl.this._currentPhysicalArchitectureCmd = new CreatePhysicalArchiCmd(systemEng[0], NamingConstants.SkeletonServicesImpl_package_name_physicalArchitecture, logicalArchitecture, logicalComponent, logicalFunction);
                SkeletonServicesImpl.this._currentPhysicalArchitectureCmd.run();
                PhysicalArchitecture physicalArchitecture = SkeletonServicesImpl.this._currentPhysicalArchitectureCmd.getPhysicalArchitecture();
                switch (engDomain_p) {
                    case System: {
                        PhysicalComponent pc = SkeletonServicesImpl.this._currentPhysicalArchitectureCmd.getPhysicalComponent();
                        SkeletonServicesImpl.this._currentEpbsArchitectureCmd = new CreateEPBSArchiCmd(systemEng[0], NamingConstants.SkeletonServicesImpl_package_name_epbsArchitecture, physicalArchitecture, pc);
                        SkeletonServicesImpl.this._currentEpbsArchitectureCmd.run();
                    }
                }
            }

            public String getName() {
                return Messages.getString("capella.sys_eng.create.cmd");
            }
        };
        TransactionHelper.getExecutionManager((EObject)project_p).execute((ICommand)createSystemEngineeringCommand);
        return systemEng[0];
    }

    @Override
    public OperationalAnalysis doOperationalAnalysis(SystemEngineering systemEng_p) {
        String architectureName = NamingConstants.SkeletonServicesImpl_package_name_operationalAnalysis;
        this._currentOpAnalysisCmd = new CreateOpAnalysisCmd(systemEng_p, architectureName);
        TransactionHelper.getExecutionManager((EObject)systemEng_p).execute((ICommand)this._currentOpAnalysisCmd);
        return this._currentOpAnalysisCmd.getOperationalAnalysis();
    }

    @Override
    public SystemAnalysis doSystemAnalysis(SystemEngineering systemEng_p, OperationalAnalysis opAnalysis_p, OperationalActivity opActivity_p) {
        String packageName = NamingConstants.SkeletonServicesImpl_package_name_systemAnalysis;
        this._currentCtxArchitectureCmd = new CreateCtxArchiCmd(systemEng_p, packageName, opAnalysis_p, opActivity_p);
        TransactionHelper.getExecutionManager((EObject)systemEng_p).execute((ICommand)this._currentCtxArchitectureCmd);
        return this._currentCtxArchitectureCmd.getSystemAnalysis();
    }

    @Override
    public LogicalArchitecture doLogicalArchitecture(SystemEngineering systemEng_p, SystemAnalysis ctxArchitecture_p, SystemFunction systemFunction_p, System system_p) {
        String packageName = NamingConstants.SkeletonServicesImpl_package_name_logicalArchitecture;
        this._currentLogicalArchitectureCmd = new CreateLogicalArchiCmd(systemEng_p, packageName, ctxArchitecture_p, systemFunction_p, system_p);
        TransactionHelper.getExecutionManager((EObject)systemEng_p).execute((ICommand)this._currentLogicalArchitectureCmd);
        return this._currentLogicalArchitectureCmd.getLogicalArchitecture();
    }

    @Override
    public PhysicalArchitecture doPhysicalArchitecture(SystemEngineering systemEng_p, LogicalArchitecture logicalArchitecture_p, LogicalComponent logicalComponent_p, LogicalFunction logicalFunction_p) {
        String packageName = NamingConstants.SkeletonServicesImpl_package_name_physicalArchitecture;
        this._currentPhysicalArchitectureCmd = new CreatePhysicalArchiCmd(systemEng_p, packageName, logicalArchitecture_p, logicalComponent_p, logicalFunction_p);
        TransactionHelper.getExecutionManager((EObject)systemEng_p).execute((ICommand)this._currentPhysicalArchitectureCmd);
        return this._currentPhysicalArchitectureCmd.getPhysicalArchitecture();
    }

    @Override
    public EPBSArchitecture doEPBSArchitecture(SystemEngineering systemEng_p, PhysicalArchitecture physicalArchitecture_p, PhysicalComponent pc_p) {
        String packageName = NamingConstants.SkeletonServicesImpl_package_name_epbsArchitecture;
        this._currentEpbsArchitectureCmd = new CreateEPBSArchiCmd(systemEng_p, packageName, physicalArchitecture_p, pc_p);
        TransactionHelper.getExecutionManager((EObject)systemEng_p).execute((ICommand)this._currentEpbsArchitectureCmd);
        return this._currentEpbsArchitectureCmd.getEPBSArchitecture();
    }
}

