/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.LogicalComponentRealization;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalContext;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.Messages;

public class CreatePhysicalArchiCmd
extends AbstractReadWriteCommand {
    private String _architectureName;
    private PhysicalArchitecture _physicalArchitecture;
    private LogicalFunction _logicalFunction;
    private LogicalComponent _logicalComponent;
    private PhysicalComponent _physicalComponent;
    private LogicalArchitecture _logicalArchitecture;
    private SystemEngineering _systemEng;

    public CreatePhysicalArchiCmd(SystemEngineering systemEng_p, String architectureName_p, LogicalArchitecture logicalArchitecture_p, LogicalComponent logicalComponent_p, LogicalFunction logicalFunction_p) {
        this._architectureName = architectureName_p;
        this._logicalFunction = logicalFunction_p;
        this._logicalComponent = logicalComponent_p;
        this._logicalArchitecture = logicalArchitecture_p;
        this._systemEng = systemEng_p;
    }

    public void run() {
        this._physicalArchitecture = PaFactory.eINSTANCE.createPhysicalArchitecture(this._architectureName);
        PhysicalFunctionPkg physicalFunctionPkg = PaFactory.eINSTANCE.createPhysicalFunctionPkg(NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name);
        this._physicalArchitecture.setOwnedFunctionPkg((FunctionPkg)physicalFunctionPkg);
        PhysicalFunction physicalFunction = PaFactory.eINSTANCE.createPhysicalFunction(NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name);
        physicalFunctionPkg.getOwnedPhysicalFunctions().add((Object)physicalFunction);
        FunctionRealization functionRealisation = FaFactory.eINSTANCE.createFunctionRealization();
        physicalFunction.getOwnedFunctionRealizations().add((Object)functionRealisation);
        functionRealisation.setSourceElement((TraceableElement)physicalFunction);
        if (this._logicalFunction != null) {
            functionRealisation.setTargetElement((TraceableElement)this._logicalFunction);
        }
        InterfacePkg interfacesPkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
        this._physicalArchitecture.setOwnedInterfacePkg(interfacesPkg);
        DataPkg dataPkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
        this._physicalArchitecture.setOwnedDataPkg(dataPkg);
        PhysicalActorPkg actorsPkg = PaFactory.eINSTANCE.createPhysicalActorPkg(NamingConstants.CreatePhysicalArchCmd_actors_pkg_name);
        this._physicalArchitecture.setOwnedPhysicalActorPkg(actorsPkg);
        this._physicalComponent = PaFactory.eINSTANCE.createPhysicalComponent(NamingConstants.CreatePhysicalArchCmd_physicalComponent_name);
        this._physicalArchitecture.setOwnedPhysicalComponent(this._physicalComponent);
        PhysicalContext physicalContext = PaFactory.eINSTANCE.createPhysicalContext(NamingConstants.CreatePhysicalArchCmd_physicalContext_name);
        this._physicalArchitecture.setOwnedPhysicalContext(physicalContext);
        Part physicalRootPart = CsFactory.eINSTANCE.createPart(this._physicalComponent.getName());
        physicalContext.getOwnedFeatures().add((Object)physicalRootPart);
        physicalRootPart.setAbstractType((AbstractType)this._physicalComponent);
        LogicalComponentRealization logicalComponentRealisation = PaFactory.eINSTANCE.createLogicalComponentRealization();
        this._physicalComponent.getOwnedLogicalComponentRealizations().add((Object)logicalComponentRealisation);
        logicalComponentRealisation.setSourceElement((TraceableElement)this._physicalComponent);
        if (this._logicalComponent != null) {
            logicalComponentRealisation.setTargetElement((TraceableElement)this._logicalComponent);
        }
        LogicalArchitectureRealization logicalArchiRealisation = PaFactory.eINSTANCE.createLogicalArchitectureRealization();
        this._physicalArchitecture.getOwnedLogicalArchitectureRealizations().add((Object)logicalArchiRealisation);
        logicalArchiRealisation.setSourceElement((TraceableElement)this._physicalArchitecture);
        if (this._logicalArchitecture != null) {
            logicalArchiRealisation.setTargetElement((TraceableElement)this._logicalArchitecture);
        }
        CapabilityRealizationPkg capaRealisationPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
        this._physicalArchitecture.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capaRealisationPkg);
        this._systemEng.getOwnedArchitectures().add((Object)this._physicalArchitecture);
    }

    public PhysicalArchitecture getPhysicalArchitecture() {
        return this._physicalArchitecture;
    }

    public PhysicalComponent getPhysicalComponent() {
        return this._physicalComponent;
    }

    public String getName() {
        return Messages.getString("capella.physical_archi.create.cmd");
    }
}

