/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.framework.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.refinement.framework.ui.IValidator;
import org.polarsys.capella.core.refinement.framework.ui.RefinementUIPlugin;
import org.polarsys.capella.core.refinement.framework.ui.SelectionPage;
import org.polarsys.capella.core.refinement.framework.ui.SelectionWizardRunnable;
import org.polarsys.capella.core.refinement.framework.ui.model.SelectionItemNode;

public class SelectionWizard
extends Wizard {
    private String nameLabel;
    private boolean isMultipleSelection = false;
    private boolean autoSelectChild = false;
    private boolean showNameTextField = false;
    private SelectionItemNode root = null;
    private String pageTitle;
    private String pageDescription;
    private SelectionPage selectionPage = null;
    private boolean selectAllByDefault = false;
    private boolean isAmbiguityResolutionPage = false;
    private String nameValue = null;
    private List<SelectionItemNode> finalSelection = null;
    private List<IValidator> validators = null;

    public SelectionWizard(SelectionItemNode root, String wizardTitle, String pageTitle, String pageDescription, boolean isMultipleSelection, boolean autoSelectChild, boolean showNameTextField, String nameLabel, boolean isAmbiguityResolutionPage) {
        this.root = root;
        this.nameLabel = nameLabel;
        this.isMultipleSelection = isMultipleSelection;
        this.autoSelectChild = autoSelectChild;
        this.pageTitle = pageTitle;
        this.pageDescription = pageDescription;
        this.showNameTextField = showNameTextField;
        this.isAmbiguityResolutionPage = isAmbiguityResolutionPage;
        this.setWindowTitle(wizardTitle);
    }

    public SelectionWizard(SelectionItemNode root, String wizardTitle, String pageTitle, String pageDescription, boolean isMultipleSelection, boolean autoSelectChild, boolean isAmbiguityResolutionPage) {
        this(root, wizardTitle, pageTitle, pageDescription, isMultipleSelection, autoSelectChild, false, "", isAmbiguityResolutionPage);
    }

    public SelectionWizard(SelectionItemNode root, String wizardTitle, String pageTitle, String pageDescription, boolean isMultipleSelection, boolean isAmbiguityResolutionPage) {
        this(root, wizardTitle, pageTitle, pageDescription, isMultipleSelection, false, isAmbiguityResolutionPage);
    }

    public SelectionWizard(SelectionItemNode root, String wizardTitle, String pageTitle, String pageDescription) {
        this(root, wizardTitle, pageTitle, pageDescription, false, false);
    }

    public Image getDefaultPageImage() {
        Image image = RefinementUIPlugin.getDefault().getImage(InteractionPackage.Literals.SCENARIO.getName());
        if (image == null) {
            image = super.getDefaultPageImage();
        }
        return image;
    }

    public void selectAllByDefault(boolean select) {
        this.selectAllByDefault = select;
    }

    public void addPages() {
        this.selectionPage = new SelectionPage(this.root, this.pageTitle, this.pageDescription, this.isMultipleSelection, this.autoSelectChild, this.selectAllByDefault, this.showNameTextField, this.nameLabel, this.isAmbiguityResolutionPage);
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean performFinish() {
        this.finalSelection = this.selectionPage.getSelection();
        this.nameValue = this.selectionPage.getNameValue();
        return true;
    }

    public SelectionItemNode getSelection() {
        if (!this.isMultipleSelection && this.finalSelection.size() == 1) {
            return this.finalSelection.get(0);
        }
        return null;
    }

    public List<SelectionItemNode> getSelectionList() {
        return this.finalSelection;
    }

    public String getNameValue() {
        return this.nameValue;
    }

    public int open() {
        SelectionWizardRunnable selectionWizardRunnable = new SelectionWizardRunnable(this);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)selectionWizardRunnable);
        return selectionWizardRunnable.getRes();
    }

    public List<IValidator> getValidators() {
        if (this.validators == null) {
            this.validators = new ArrayList<IValidator>();
        }
        return this.validators;
    }

    public void addValidator(IValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<IValidator>();
        }
        this.validators.add(validator);
    }
}

