/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.ext.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.ui.internal.refresh.SynchronizeGMFModelCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.part.OffscreenEditPartFactory;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.ext.command.CreateEdgeCommand;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.ext.command.CreateNodeCommand;

public abstract class AbstractRepresentationCreationOperation
extends WorkspaceModifyOperation {
    protected List<EObject> semanticElemens = new ArrayList<EObject>();
    private static final String _AIRD_FILE_EXTENSION = "aird";
    private String _viewpointPluginID = "";
    private String _viewpointName = "";
    private List<String> _representationsNames = new ArrayList<String>();
    protected Set<Viewpoint> viewpoints = new HashSet<Viewpoint>();
    protected List<RepresentationDescription> representationsDescriptions = new ArrayList<RepresentationDescription>();
    private String representationFileName;
    private URI representationFileURI;
    private IProject representationProject;
    private URI _modelURI;

    public abstract List<EObject> getSemanticElements(Session var1, URI var2);

    public abstract String getLabelFrom(EObject var1, RepresentationDescription var2);

    public abstract boolean initializeDiagram(DDiagram var1);

    public AbstractRepresentationCreationOperation(URI modelURI, String fileName, String viewpointPluginID, String viewpointName) {
        this(modelURI, fileName, viewpointPluginID, viewpointName, null);
    }

    public AbstractRepresentationCreationOperation(URI modelURI, String fileName, String viewpointPluginID, String viewpointName, List<String> representations) {
        this._modelURI = modelURI;
        this._viewpointName = viewpointName;
        this._viewpointPluginID = viewpointPluginID;
        this._representationsNames = representations;
        this.initRepresentationFileInformations(fileName);
        this.initViewpointsList(representations == null);
    }

    private void initRepresentationFileInformations(String fileName) {
        this.representationFileName = this.getRepresentationFileName(fileName);
        this.representationFileURI = this.getRepresentationUri(fileName);
        this.representationProject = this.getRepresentationProject(fileName);
    }

    private void initViewpointsList(boolean allRepresentations) {
        for (Viewpoint viewpoint : ViewpointRegistry.getInstance().getViewpoints()) {
            if (!viewpoint.getName().equals(this._viewpointName) || !viewpoint.eResource().getURI().segmentsList().contains(this._viewpointPluginID)) continue;
            this.viewpoints.add(viewpoint);
            break;
        }
        if (!this.viewpoints.isEmpty()) {
            for (Viewpoint viewpoint : this.viewpoints) {
                EList ownedRepresentations = viewpoint.getOwnedRepresentations();
                if (ownedRepresentations == null || ownedRepresentations.isEmpty()) continue;
                if (allRepresentations) {
                    this._representationsNames = new ArrayList<String>();
                    this.representationsDescriptions.addAll((Collection<RepresentationDescription>)ownedRepresentations);
                    for (RepresentationDescription representationDescription : ownedRepresentations) {
                        this._representationsNames.add(representationDescription.getName());
                    }
                    continue;
                }
                for (RepresentationDescription representationDescription : ownedRepresentations) {
                    String name = representationDescription.getName();
                    if (!this._representationsNames.contains(name)) continue;
                    this.representationsDescriptions.add(representationDescription);
                }
            }
        }
    }

    private boolean canGenerate() {
        if (this._modelURI == null) {
            return false;
        }
        if (this._viewpointName == null || this._viewpointName.isEmpty()) {
            return false;
        }
        if (this._viewpointPluginID == null || this._viewpointPluginID.isEmpty()) {
            return false;
        }
        return this._representationsNames != null && !this._representationsNames.isEmpty();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (!this.canGenerate()) {
            return;
        }
        Session session = this.createRepresentationFile(monitor);
        if (session != null) {
            this.semanticElemens = this.getSemanticElements(session, this._modelURI);
            List<DRepresentation> newAndCreatedRepresentations = this.createRepresentations(session, monitor);
            if (!newAndCreatedRepresentations.isEmpty()) {
                for (DRepresentation dRepresentation : newAndCreatedRepresentations) {
                    if (dRepresentation instanceof DDiagram && this.initializeDiagram((DDiagram)dRepresentation)) {
                        this.populateEntitiesDiagram(session, (DDiagram)dRepresentation);
                    }
                    this.refreshRepresentation(session, dRepresentation);
                    if (!(dRepresentation instanceof DDiagram)) continue;
                    this.arrangeAll(session, (DDiagram)dRepresentation);
                }
            }
            session.save(monitor);
        }
    }

    private void populateEntitiesDiagram(Session session, DDiagram diagram) {
        List<EObject> semantics = this.getSemanticElements(session, this._modelURI);
        for (EObject semantic : semantics) {
            this.populateNodesAndContainers(session, diagram, semantic);
            this.populateEdges(session, diagram, semantic);
        }
    }

    private void populateEdges(Session session, DDiagram diagram, EObject ePackage) {
        DiagramDescription description = diagram.getDescription();
        EList allEdgeMappings = description.getDefaultLayer().getEdgeMappings();
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        for (EdgeMapping edgeMapping : allEdgeMappings) {
            boolean useDomainElement = edgeMapping.isUseDomainElement();
            if (useDomainElement) {
                EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(edgeMapping);
                Collection candidates = edgeMappingQuery.evaluateCandidateExpression((DSemanticDiagram)diagram, session.getInterpreter(), (DragAndDropTarget)diagram);
                for (EObject eObject : candidates) {
                    CreateEdgeCommand command = new CreateEdgeCommand(session, diagram, edgeMapping, eObject, useDomainElement);
                    transactionalEditingDomain.getCommandStack().execute((Command)command);
                }
                continue;
            }
            for (EObject semantic : ePackage.eContents()) {
                CreateEdgeCommand command = new CreateEdgeCommand(session, diagram, edgeMapping, semantic, useDomainElement);
                transactionalEditingDomain.getCommandStack().execute((Command)command);
            }
        }
        transactionalEditingDomain.getCommandStack().flush();
    }

    private void populateNodesAndContainers(Session session, DDiagram diagram, EObject ePackage) {
        EList containerMappings;
        BasicEList abstractNodeMappings = new BasicEList();
        DiagramDescription description = diagram.getDescription();
        EList nodeMappings = description.getAllNodeMappings();
        if (!nodeMappings.isEmpty()) {
            abstractNodeMappings.addAll((Collection)nodeMappings);
        }
        if (!(containerMappings = description.getAllContainerMappings()).isEmpty()) {
            abstractNodeMappings.addAll((Collection)containerMappings);
        }
        ModelAccessor modelAccessor = session.getModelAccessor();
        for (AbstractNodeMapping abstractNodeMapping : abstractNodeMappings) {
            String domainClass = abstractNodeMapping.getDomainClass();
            for (EObject element : ePackage.eContents()) {
                if (!modelAccessor.eInstanceOf(element, domainClass)) continue;
                CreateNodeCommand command = new CreateNodeCommand(session, diagram, abstractNodeMapping, element);
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
            }
        }
    }

    private List<DRepresentation> createRepresentations(Session session, IProgressMonitor monitor) {
        ArrayList<DRepresentation> result = new ArrayList<DRepresentation>();
        for (EObject semantic : this.semanticElemens) {
            Collection representations = DialectManager.INSTANCE.getRepresentations(semantic, session);
            if (representations.isEmpty()) {
                for (String representationName : this._representationsNames) {
                    DRepresentation newRepresentation = this.createRepresentation(semantic, session, representationName, monitor);
                    if (newRepresentation == null) continue;
                    result.add(newRepresentation);
                }
                continue;
            }
            ArrayList<String> availableRepresentation = new ArrayList<String>();
            for (DRepresentation representation : representations) {
                DiagramDescription description = null;
                if (representation instanceof DDiagram) {
                    DDiagram dDiagram = (DDiagram)representation;
                    description = dDiagram.getDescription();
                }
                if (representation instanceof DTable) {
                    DTable dTable = (DTable)representation;
                    description = dTable.getDescription();
                }
                if (description == null) continue;
                availableRepresentation.add(description.getName());
                for (RepresentationDescription desc : this.representationsDescriptions) {
                    if (!desc.getName().equals(description.getName())) continue;
                    result.add(representation);
                }
            }
            for (String string : this._representationsNames) {
                DRepresentation newRepresentation;
                if (availableRepresentation.contains(string) || (newRepresentation = this.createRepresentation(semantic, session, string, monitor)) == null) continue;
                result.add(newRepresentation);
            }
        }
        return result;
    }

    private DRepresentation createRepresentation(EObject semantic, Session session, String representationName, IProgressMonitor monitor) {
        RepresentationDescription representationDescription = this.getRepresentationDescription(representationName);
        String domainClass = null;
        if (representationDescription instanceof DiagramDescription) {
            domainClass = ((DiagramDescription)representationDescription).getDomainClass();
        }
        if (representationDescription instanceof TableDescription) {
            domainClass = ((TableDescription)representationDescription).getDomainClass();
        }
        DRepresentation createRepresentation = null;
        if (domainClass != null && session.getModelAccessor().eInstanceOf(semantic, domainClass)) {
            createRepresentation = this.createRepresentation(semantic, session, representationDescription, monitor);
        }
        return createRepresentation;
    }

    private RepresentationDescription getRepresentationDescription(String representationName) {
        for (RepresentationDescription representation : this.representationsDescriptions) {
            if (!representation.getName().equals(representationName)) continue;
            return representation;
        }
        return null;
    }

    private DRepresentation createRepresentation(EObject semantic, Session session, RepresentationDescription description, IProgressMonitor monitor) {
        String name = this.getLabelFrom(semantic, description);
        CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(session, description, semantic, name, monitor);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)createRepresentationCommand);
        DRepresentation createdRepresentation = createRepresentationCommand.getCreatedRepresentation();
        return createdRepresentation;
    }

    private void arrangeAll(Session session, DDiagram diagram) {
        DiagramCreationUtil util = new DiagramCreationUtil(diagram);
        Diagram associatedGMFDiagram = null;
        if (!util.findAssociatedGMFDiagram()) {
            util.createNewGMFDiagram();
            associatedGMFDiagram = util.getAssociatedGMFDiagram();
            if (associatedGMFDiagram != null) {
                session.getServices().putCustomData("GMF_DIAGRAMS", (EObject)diagram, (EObject)associatedGMFDiagram);
            }
        } else {
            associatedGMFDiagram = util.getAssociatedGMFDiagram();
        }
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        if (associatedGMFDiagram != null) {
            CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(associatedGMFDiagram);
            SynchronizeGMFModelCommand gmfNotationModelSynchronizationCmd = new SynchronizeGMFModelCommand(domain, canonicalSynchronizer);
            domain.getCommandStack().execute((Command)gmfNotationModelSynchronizationCmd);
        }
        final Diagram associatedGMFDiagram_f = associatedGMFDiagram;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                List layoutNodes;
                Shell shell = new Shell(Display.getDefault());
                DiagramEditPart diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(associatedGMFDiagram_f, shell);
                ListIterator listIterator = associatedGMFDiagram_f.getChildren().listIterator();
                while (listIterator.hasNext()) {
                    Object next = listIterator.next();
                    GraphicalEditPart g = (GraphicalEditPart)diagramEP.getPrimaryEditParts().get(0);
                    next.toString();
                    diagramEP.getViewer().getEditPartRegistry().put(next, g);
                }
                ArrayList<String> hints = new ArrayList<String>(2);
                hints.add("DEFAULT");
                hints.add((String)diagramEP);
                ObjectAdapter layoutHint = new ObjectAdapter(hints);
                EList children = null;
                try {
                    children = associatedGMFDiagram_f.getChildren();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (children != null && !children.isEmpty() && !(layoutNodes = LayoutService.getInstance().getLayoutNodes(diagramEP, (List)associatedGMFDiagram_f.getChildren())).isEmpty()) {
                    Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(layoutNodes, false, (IAdaptable)layoutHint);
                    layoutRun.run();
                }
            }
        });
    }

    private void refreshRepresentation(Session session, final DRepresentation representation) {
        TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                representation.refresh();
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    private Session createRepresentationFile(IProgressMonitor monitor) {
        monitor.subTask("create the representation model...");
        IProject project = this.representationProject;
        Session session = SessionManager.INSTANCE.getSession(this.representationFileURI, (IProgressMonitor)new NullProgressMonitor());
        if (session == null) {
            session = AbstractRepresentationCreationOperation.createAird(project, this.representationFileURI, monitor);
        }
        if (session == null) {
            throw new RuntimeException("Can't create a session for " + this.representationFileURI.toString());
        }
        session.save(monitor);
        session.open(monitor);
        AddSemanticResourceCommand addSemanticResourceCommand = new AddSemanticResourceCommand(session, this._modelURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ChangeViewpointSelectionCommand changeViewpointSelectionCommand = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), this.viewpoints, Collections.emptySet(), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        CompoundCommand compoundCommand = new CompoundCommand("Link resources to representation");
        compoundCommand.append((Command)addSemanticResourceCommand);
        compoundCommand.append((Command)changeViewpointSelectionCommand);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)compoundCommand);
        return session;
    }

    public static Session createAird(IProject project, URI representationsURI, IProgressMonitor monitor) {
        Session session = null;
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        if (modelingProject.some()) {
            session = ((ModelingProject)modelingProject.get()).getSession();
        }
        if (session == null) {
            DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, monitor);
            try {
                sessionCreationOperation.execute();
                session = sessionCreationOperation.getCreatedSession();
            }
            catch (CoreException e) {
                throw new RuntimeException("Can't create session for " + representationsURI, e);
            }
        }
        return session;
    }

    private URI getRepresentationUri(String fileName) {
        String stringRepresentationURI = "";
        if (this.isFqnFileName(fileName)) {
            stringRepresentationURI = fileName;
        } else {
            URI modelUriWithoutFileExtension = this._modelURI.trimFileExtension();
            if (modelUriWithoutFileExtension != null && modelUriWithoutFileExtension.segmentCount() > 1) {
                int i = 1;
                while (i < modelUriWithoutFileExtension.segments().length - 1) {
                    stringRepresentationURI = String.valueOf(stringRepresentationURI) + "/" + modelUriWithoutFileExtension.segments()[i];
                    ++i;
                }
                stringRepresentationURI = String.valueOf(stringRepresentationURI) + "/" + this.representationFileName;
            } else {
                throw new RuntimeException("Model URI is not valid");
            }
        }
        if (stringRepresentationURI.length() > 0) {
            return URI.createPlatformResourceURI((String)stringRepresentationURI, (boolean)true);
        }
        throw new RuntimeException("Error on creating representation URI");
    }

    private boolean isFqnFileName(String fileName) {
        return fileName != null && !fileName.isEmpty() && fileName.contains("/");
    }

    private String getRepresentationFileName(String fileName) {
        if (fileName == null || fileName != null && fileName.trim().length() < 1) {
            URI modelUriWithoutFileExtension = this._modelURI.trimFileExtension();
            if (modelUriWithoutFileExtension != null && modelUriWithoutFileExtension.segmentCount() > 1) {
                String modelName = modelUriWithoutFileExtension.lastSegment();
                modelName = String.valueOf(modelName) + ".aird";
                return modelName;
            }
            throw new RuntimeException("Model file URI is not valid");
        }
        boolean fqnFileName = this.isFqnFileName(fileName);
        if (fqnFileName) {
            String[] segments = fileName.split("/");
            String lastSegment = segments[segments.length - 1];
            if (lastSegment.contains(_AIRD_FILE_EXTENSION)) {
                return lastSegment;
            }
            return String.valueOf(lastSegment) + "." + _AIRD_FILE_EXTENSION;
        }
        return fileName;
    }

    private IProject getRepresentationProject(String fileName) {
        String projectName = null;
        ArrayList<String> foldersToCreate = new ArrayList<String>();
        if (this.isFqnFileName(fileName)) {
            String[] segments = fileName.split("/");
            projectName = segments[0];
            int i = 1;
            while (i < segments.length - 1) {
                foldersToCreate.add(segments[i]);
                ++i;
            }
        } else {
            projectName = this._modelURI.isPlatform() ? this._modelURI.segment(1) : this._modelURI.segment(0);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        NullProgressMonitor NPM = new NullProgressMonitor();
        try {
            if (!project.exists()) {
                project.create((IProgressMonitor)NPM);
            }
            project.open((IProgressMonitor)NPM);
        }
        catch (CoreException e) {
            throw new RuntimeException("Project with name : " + projectName + " can't be localized", e);
        }
        if (!foldersToCreate.isEmpty()) {
            IFolder currentFolder = null;
            for (String folderName : foldersToCreate) {
                if ((currentFolder = currentFolder == null ? project.getFolder(folderName) : currentFolder.getFolder(folderName)).exists()) continue;
                try {
                    currentFolder.create(true, true, (IProgressMonitor)NPM);
                }
                catch (CoreException e) {
                    throw new RuntimeException("Can't create folder : " + currentFolder, e);
                }
            }
        }
        return project;
    }
}

