/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public class ContributorTrackingSet
extends LinkedHashSet {
    private static final long serialVersionUID = 2516241537206281972L;
    private INavigatorContentDescriptor contributor;
    private INavigatorContentDescriptor firstClassContributor;
    private NavigatorContentService contentService;

    public ContributorTrackingSet(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public ContributorTrackingSet(NavigatorContentService aContentService, Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            super.add(elements[i]);
            ++i;
        }
        this.contentService = aContentService;
    }

    @Override
    public boolean add(Object o) {
        if (this.contributor != null) {
            this.contentService.rememberContribution(this.contributor, this.firstClassContributor, o);
        }
        return super.add(o);
    }

    @Override
    public boolean remove(Object o) {
        this.contentService.forgetContribution(o);
        return super.remove(o);
    }

    @Override
    public void clear() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            this.contentService.forgetContribution(it.next());
        }
        super.clear();
    }

    public INavigatorContentDescriptor getContributor() {
        return this.contributor;
    }

    public INavigatorContentDescriptor getFirstClassContributor() {
        return this.firstClassContributor;
    }

    public void setContributor(INavigatorContentDescriptor newContributor, INavigatorContentDescriptor theFirstClassContributor) {
        this.contributor = newContributor;
        this.firstClassContributor = theFirstClassContributor;
    }

    public void setContents(Object[] contents) {
        super.clear();
        if (contents != null) {
            int i = 0;
            while (i < contents.length) {
                this.add(contents[i]);
                ++i;
            }
        }
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator delegateIterator;
            Object current;
            {
                this.delegateIterator = ContributorTrackingSet.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public Object next() {
                this.current = this.delegateIterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                ContributorTrackingSet.this.contentService.forgetContribution(this.current);
            }
        };
    }
}

