/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.templates;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.BuildcoreFactory;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Chain;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Deployment;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Job;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Property;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.PropertyType;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.SCM;
import org.eclipse.egf.portfolio.eclipse.build.builddeploy.BuilddeployFactory;
import org.eclipse.egf.portfolio.eclipse.build.builddeploy.CronTrigger;
import org.eclipse.egf.portfolio.eclipse.build.builddeploy.GenerationLocation;
import org.eclipse.egf.portfolio.eclipse.build.builddeploy.HudsonDeployment;
import org.eclipse.egf.portfolio.eclipse.build.builddeploy.PermissionType;
import org.eclipse.egf.portfolio.eclipse.build.builddeploy.SCMTrigger;
import org.eclipse.egf.portfolio.eclipse.build.builddeploy.User;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.BuildscmFactory;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.GIT;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.GITBuildLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.GITGenerationLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.GITLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.GITProtocol;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVN;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVNBuildLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVNGenerationLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVNLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVNProtocol;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.BuildStep;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.BuildstepFactory;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.CLEAN_TYPE;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.CleanStep;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.Component;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.Feature;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.InstallStep;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.PublishStep;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.TargetPlatformBuildLocation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.UserPermission;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util.BuildDataConfigContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.preferences.kitalphaPreferences.PreferencesConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFBuildHelper {
    private static final String PROTOCOL_SVN = "svn";
    private static final String PROTOCOL_SSH = "svnssh";

    public static Chain createChainOfJobs(Collection<Job> jobs, String lvpShortName) {
        Chain chain = BuildcoreFactory.eINSTANCE.createChain();
        chain.setName(lvpShortName);
        chain.setEnabled(true);
        if (jobs != null) {
            Iterator<Job> it = jobs.iterator();
            while (it.hasNext()) {
                chain.getJobs().add((Object)it.next());
            }
        }
        return chain;
    }

    public static Job createMainJob(String installStep_id, String protocol, String rootProjectName, String lvpsShortName, String repositoryLocation, BuildDataConfigContainer<String> conf) {
        Job mainJob = BuildcoreFactory.eINSTANCE.createJob();
        mainJob.setName("main");
        mainJob.getSteps().add((Object)EGFBuildHelper.createCleanStep());
        InstallStep install = EGFBuildHelper.createInstallStep("viewpoint_" + lvpsShortName);
        install.setName("viewpoint_" + lvpsShortName);
        install.setProfile("SDKProfil");
        mainJob.getSteps().add((Object)install);
        SCM scm = null;
        if (conf.iscanManageCronTriggers() || conf.iscanManageGenerationLocation() || conf.iscanManageHudsonProperties() || conf.iscanManageSCMTriggers() || conf.iscanManageUsers()) {
            HudsonDeployment hudson = EGFBuildHelper.createHudsonDeployment(conf, scm, lvpsShortName, protocol, rootProjectName, repositoryLocation);
            mainJob.setDeployment((Deployment)hudson);
        }
        return mainJob;
    }

    public static Job createViewpointBuildJob(String targetLocation, String repositoryLocation, String protocol, String rootProjectName, String lvpsShortName, BuildDataConfigContainer<String> conf) {
        Job buildJob = BuildcoreFactory.eINSTANCE.createJob();
        buildJob.setName("build_" + lvpsShortName);
        buildJob.getProperties().add((Object)EGFBuildHelper.createProperty("target.location", targetLocation, PropertyType.INLINED));
        buildJob.getProperties().add((Object)EGFBuildHelper.createProperty("repository.location", repositoryLocation, PropertyType.RUNTIME));
        BuildStep buildStep = null;
        if (protocol.contains(PROTOCOL_SVN)) {
            SVN svn = BuildscmFactory.eINSTANCE.createSVN();
            SVNLocation svnLocation = EGFBuildHelper.createSVNLocation("svn_viewpoint", protocol);
            svn.getLocations().add((Object)svnLocation);
            buildJob.setScms((SCM)svn);
            buildStep = EGFBuildHelper.createBuildStep(conf, svnLocation);
        } else {
            GIT git = BuildscmFactory.eINSTANCE.createGIT();
            GITLocation gitLocation = EGFBuildHelper.createGITLocation("git_viewpoint", protocol);
            git.setLocations(gitLocation);
            gitLocation.setBranch("master");
            buildJob.setScms((SCM)git);
            buildStep = EGFBuildHelper.createBuildStep(conf, gitLocation);
        }
        buildJob.getSteps().add((Object)EGFBuildHelper.createCleanStep());
        buildStep.setName(lvpsShortName);
        TargetPlatformBuildLocation targePlatform = BuildstepFactory.eINSTANCE.createTargetPlatformBuildLocation();
        targePlatform.setPath("${target.location}");
        Feature feature = BuildstepFactory.eINSTANCE.createFeature();
        feature.setId(PreferencesConstants.getBuildPreferences((String)"features-root-path-pref"));
        buildStep.getBuildLocations().add((Object)targePlatform);
        buildStep.getComponents().add((Object)feature);
        buildJob.getSteps().add((Object)buildStep);
        PublishStep publish = BuildstepFactory.eINSTANCE.createPublishStep();
        publish.setComponent((Component)feature);
        publish.setEnabled(true);
        publish.setGenerateDropins(true);
        publish.setGenerateSources(false);
        buildJob.getSteps().add((Object)publish);
        InstallStep install = EGFBuildHelper.createInstallStep("viewpoint_" + lvpsShortName);
        install.setName(String.valueOf(lvpsShortName) + " feature");
        install.setProfile("SDKProfil");
        buildJob.getSteps().add((Object)install);
        return buildJob;
    }

    private static BuildStep createBuildStep(BuildDataConfigContainer<String> conf, GITLocation gitLocation) {
        BuildStep build = BuildstepFactory.eINSTANCE.createBuildStep();
        List<String> sourceFolders = conf.getList("source.folders");
        if (sourceFolders != null) {
            for (String folder : sourceFolders) {
                GITBuildLocation gitBuildLocation = BuildscmFactory.eINSTANCE.createGITBuildLocation();
                gitBuildLocation.setFolderName(folder);
                gitBuildLocation.setGitLocation(gitLocation);
                build.getBuildLocations().add((Object)gitBuildLocation);
            }
        }
        return build;
    }

    private static GITLocation createGITLocation(String url, String protocol) {
        GITLocation location = BuildscmFactory.eINSTANCE.createGITLocation();
        location.setProtocol(GITProtocol.HTTP);
        location.setLocalPath(url);
        location.setUrl("${repository.location}");
        return location;
    }

    public static SVNLocation createSVNLocation(String url, String protocol) {
        SVNLocation svn_location = BuildscmFactory.eINSTANCE.createSVNLocation();
        if (protocol.equals(PROTOCOL_SVN)) {
            svn_location.setProtocol(SVNProtocol.SVN);
        }
        if (protocol.equals(PROTOCOL_SSH)) {
            svn_location.setProtocol(SVNProtocol.SVNSSH);
        }
        svn_location.setLocalPath(url);
        svn_location.setUrl("${repository.location}");
        return svn_location;
    }

    private static Property createProperty(String key, String value, PropertyType type) {
        Property prop = BuildcoreFactory.eINSTANCE.createProperty();
        prop.setKey(key);
        prop.setValue(value);
        prop.setType(type);
        return prop;
    }

    public static CleanStep createCleanStep() {
        CleanStep clean = BuildstepFactory.eINSTANCE.createCleanStep();
        clean.setType(CLEAN_TYPE.RESULT);
        return clean;
    }

    public static InstallStep createInstallStep(String id) {
        InstallStep install = BuildstepFactory.eINSTANCE.createInstallStep();
        install.setId(id);
        return install;
    }

    public static HudsonDeployment createHudsonDeployment(BuildDataConfigContainer<String> conf, SCM scm, String lvpsShortName, String protocol, String rootProjectName, String repositoryLocation) {
        HudsonDeployment hudsonDeployment = BuilddeployFactory.eINSTANCE.createHudsonDeployment();
        if (conf.iscanManageHudsonProperties()) {
            EGFBuildHelper.setHudsonProperties(hudsonDeployment, conf.getMap("hudson.properties"));
        }
        if (conf.iscanManageUsers()) {
            EGFBuildHelper.setHudsonUsers(hudsonDeployment, conf.getMap("build.users"));
        }
        if (conf.iscanManageGenerationLocation()) {
            EGFBuildHelper.setHudsonGenerationLocation(hudsonDeployment, conf.getMap("generation.location"), scm, lvpsShortName, protocol, rootProjectName, repositoryLocation);
        }
        if (conf.iscanManageCronTriggers()) {
            EGFBuildHelper.setHudsonCronTriggers(hudsonDeployment, conf.getList("cron.triggers"));
        }
        if (conf.iscanManageSCMTriggers()) {
            EGFBuildHelper.setHudsonSCMTriggers(hudsonDeployment, conf.getList("scm.triggers"));
        }
        return hudsonDeployment;
    }

    public static BuildStep createBuildStep(BuildDataConfigContainer<String> conf, SVNLocation svnLocation) {
        BuildStep build = BuildstepFactory.eINSTANCE.createBuildStep();
        List<String> sourceFolders = conf.getList("source.folders");
        if (sourceFolders != null) {
            for (String folder : sourceFolders) {
                SVNBuildLocation svnBuildLocation = BuildscmFactory.eINSTANCE.createSVNBuildLocation();
                svnBuildLocation.setFolderName(folder);
                svnBuildLocation.setSvnLocation(svnLocation);
                build.getBuildLocations().add((Object)svnBuildLocation);
            }
        }
        return build;
    }

    private static void setHudsonSCMTriggers(HudsonDeployment hudsonDeployment, List<String> triggers) {
        if (triggers != null) {
            for (String planning : triggers) {
                SCMTrigger scmTrigger = BuilddeployFactory.eINSTANCE.createSCMTrigger();
                scmTrigger.setPlanning(planning);
                hudsonDeployment.getTriggers().add((Object)scmTrigger);
            }
        }
    }

    private static void setHudsonGenerationLocation(HudsonDeployment hudsonDeployment, Map<String, String> generationLocation, SCM scm, String lvpsShortName, String protocol, String rootProjectName, String repositoryLocation) {
        if (protocol.contains(PROTOCOL_SVN)) {
            EGFBuildHelper.generateSVNLocation(hudsonDeployment, generationLocation, scm, lvpsShortName, protocol, rootProjectName, repositoryLocation);
        } else {
            EGFBuildHelper.generateGitLocation(hudsonDeployment, generationLocation, scm, lvpsShortName, protocol, rootProjectName, repositoryLocation);
        }
    }

    private static void generateGitLocation(HudsonDeployment hudsonDeployment, Map<String, String> generationLocation, SCM scm, String lvpsShortName, String protocol, String rootProjectName, String repositoryLocation) {
        Iterator<String> iterator;
        GITGenerationLocation gitGenerationLocation = BuildscmFactory.eINSTANCE.createGITGenerationLocation();
        if (generationLocation != null && (iterator = generationLocation.keySet().iterator()).hasNext()) {
            String key = iterator.next();
            gitGenerationLocation.setFolderName(key);
            GITLocation gitLocation = BuildscmFactory.eINSTANCE.createGITLocation();
            String url = generationLocation.get(key);
            if (url != null) {
                gitLocation.setUrl(generationLocation.get(key));
                gitLocation.setLocalPath(String.valueOf(lvpsShortName) + "_releng");
            } else {
                url = repositoryLocation.endsWith("/") ? String.valueOf(repositoryLocation) + rootProjectName + "." + lvpsShortName + ".releng" : String.valueOf(repositoryLocation) + "/" + rootProjectName + "." + lvpsShortName + ".releng";
                gitLocation.setUrl(url);
            }
            gitLocation.setProtocol(GITProtocol.HTTP);
            gitGenerationLocation.setGitLocation(gitLocation);
        }
        hudsonDeployment.setGenerationLocation((GenerationLocation)gitGenerationLocation);
    }

    private static void generateSVNLocation(HudsonDeployment hudsonDeployment, Map<String, String> generationLocation, SCM scm, String lvpsShortName, String protocol, String rootProjectName, String repositoryLocation) {
        Iterator<String> iterator;
        SVNGenerationLocation svnGenerationLocation = BuildscmFactory.eINSTANCE.createSVNGenerationLocation();
        if (generationLocation != null && (iterator = generationLocation.keySet().iterator()).hasNext()) {
            String key = iterator.next();
            svnGenerationLocation.setFolderName(key);
            SVNLocation svnLocation = BuildscmFactory.eINSTANCE.createSVNLocation();
            String url = generationLocation.get(key);
            if (url != null) {
                svnLocation.setUrl(generationLocation.get(key));
                svnLocation.setLocalPath(String.valueOf(lvpsShortName) + "_releng");
            } else {
                url = repositoryLocation.endsWith("/") ? String.valueOf(repositoryLocation) + rootProjectName + "." + lvpsShortName + ".releng" : String.valueOf(repositoryLocation) + "/" + rootProjectName + "." + lvpsShortName + ".releng";
                svnLocation.setUrl(url);
            }
            if (protocol.equals(PROTOCOL_SVN)) {
                svnLocation.setProtocol(SVNProtocol.SVN);
            }
            if (protocol.equals(PROTOCOL_SSH)) {
                svnLocation.setProtocol(SVNProtocol.SVNSSH);
            }
            if (scm instanceof SVN) {
                ((SVN)scm).getLocations().add((Object)svnLocation);
            }
            svnGenerationLocation.setSvnLocation(svnLocation);
        }
        hudsonDeployment.setGenerationLocation((GenerationLocation)svnGenerationLocation);
    }

    private static void setHudsonCronTriggers(HudsonDeployment hudsonDeployment, List<String> triggers) {
        if (triggers != null) {
            for (String planning : triggers) {
                CronTrigger cronTrigger = BuilddeployFactory.eINSTANCE.createCronTrigger();
                cronTrigger.setPlanning(planning);
                hudsonDeployment.getTriggers().add((Object)cronTrigger);
            }
        }
    }

    private static void setHudsonUsers(HudsonDeployment deployment, Map<String, String> users) {
        if (users != null) {
            for (String login : users.keySet()) {
                User user = BuilddeployFactory.eINSTANCE.createUser();
                user.setLogin(login);
                String permission = users.get(login);
                if (permission != null) {
                    if (permission.equals(UserPermission.WRITE.toString())) {
                        user.setPermission(PermissionType.WRITE);
                    }
                    if (permission.equals(UserPermission.EXECUTE.toString())) {
                        user.setPermission(PermissionType.EXECUTE);
                    }
                }
                deployment.getUsers().add((Object)user);
            }
        }
    }

    private static void setHudsonProperties(HudsonDeployment hudsonDeployment, Map<String, String> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                String tmp;
                if (key.equals("antName") && (tmp = properties.get(key)) != null && !tmp.equals("")) {
                    hudsonDeployment.setAntName(new String(tmp));
                }
                if (key.equals("assignedNode") && (tmp = properties.get(key)) != null && !tmp.equals("")) {
                    hudsonDeployment.setAssignedNode(new String(tmp));
                }
                if (key.equals("build_id") && (tmp = properties.get(key)) != null && !tmp.equals("")) {
                    hudsonDeployment.setBuildId(new String(tmp));
                }
                if (key.equals("enabled") && (tmp = properties.get(key)) != null && !tmp.equals("") && tmp.equals("false")) {
                    hudsonDeployment.setEnabled(false);
                }
                if (key.equals("jdkName") && (tmp = properties.get(key)) != null && !tmp.equals("")) {
                    hudsonDeployment.setJdkName(new String(tmp));
                }
                if (key.equals("userDeployJobName") && (tmp = properties.get(key)) != null && !tmp.equals("")) {
                    hudsonDeployment.setUserDeployJobName(new String(tmp));
                }
                if (!key.equals("userDeployServerUrl") || (tmp = properties.get(key)) == null || tmp.equals("")) continue;
                hudsonDeployment.setUserDeployServerUrl(new String(tmp));
            }
        }
    }
}

