/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.common.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionController;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationFactory;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.ui.toolkit.decomposition.Decomposition;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModelEvent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModelListener;

public class LCDecompositionOperations
implements DecompositionModelListener {
    private static final Logger _logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private LCDecompositionController _controller;

    public void decompositionChanged(DecompositionModelEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.addNewDecomposition(event);
                break;
            }
            case 3: {
                this.removeAllDecompositions(event);
                break;
            }
            case 2: {
                this.removeDecomposition(event);
                break;
            }
            case 4: {
                this.renameDecomposition(event);
                break;
            }
            case 5: {
                this.addNewTargetComponent(event);
                break;
            }
            case 6: {
                this.removeTargetComponent(event);
                break;
            }
            case 7: {
                this.removeAllTargetComponents(event);
                break;
            }
            case 8: {
                this.renameTargetComponent(event);
                break;
            }
            case 11: {
                this.wrapReusedTargetComponent(event);
                break;
            }
            case 9: {
                this.attachInterface(event);
                break;
            }
            case 10: {
                this.detachInterface(event);
                break;
            }
            case 12: {
                this.finishDecomposition(event);
                break;
            }
        }
    }

    private void wrapReusedTargetComponent(DecompositionModelEvent event) {
        try {
            DecompositionComponent shortcutComp = new DecompositionComponent();
            Object obj = event.getCurrentData();
            if (obj instanceof LogicalComponent) {
                LogicalComponent comp = (LogicalComponent)obj;
                shortcutComp.setName(comp.getName());
                shortcutComp.setValue((Object)comp);
                shortcutComp.setReusedComponent(true);
                shortcutComp.setItems(this._controller.getWrappedInterfaces(comp, false));
                shortcutComp.setReusedTarget((Object)comp);
                shortcutComp.setPath(this._controller.getElementPath(comp));
                event.setReusedComponent(shortcutComp);
            }
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setReusedComponent(null);
        }
    }

    private void detachInterface(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    private void attachInterface(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    public void addNewTargetComponent(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            exception.printStackTrace();
            event.setOperationSuccess(false);
        }
    }

    private void renameTargetComponent(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    private void removeAllTargetComponents(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    private void removeTargetComponent(DecompositionModelEvent event) {
        try {
            this._controller.setUserHasDeletedSubComponent(true);
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    public void addNewDecomposition(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    private void renameDecomposition(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    private void removeDecomposition(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.warn((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    private void removeAllDecompositions(DecompositionModelEvent event) {
        try {
            this._controller.triggerView();
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            event.setOperationSuccess(false);
        }
    }

    private void finishDecomposition(DecompositionModelEvent event) {
        try {
            final DecompositionModel model = (DecompositionModel)event.getSource();
            DecompositionComponent sourceComponent = model.getSourceComponent();
            final LogicalComponent sourceLC = (LogicalComponent)sourceComponent.getValue();
            if (model.getDecompositions().size() == 1) {
                this.addSubLCs((Decomposition)model.getDecompositions().get(0), sourceLC);
            }
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    List targetComponents = LCDecompositionOperations.this.removeLCs(model, sourceLC);
                    LCDecompositionOperations.this.removeInterfaces(targetComponents);
                }
            };
            TransactionHelper.getExecutionManager((EObject)sourceLC).execute((ICommand)command);
            event.setOperationSuccess(true);
        }
        catch (Exception exception) {
            _logger.debug((Object)new EmbeddedMessage(exception.getMessage(), "User Interface"));
            exception.printStackTrace();
            event.setOperationSuccess(false);
        }
    }

    private void removeInterfaces(List<DecompositionComponent> targetComponents) {
        for (DecompositionComponent decompositionComponent : targetComponents) {
            LogicalComponent lc;
            Object valueme;
            HashMap<Object, Interface> usedAndImpInterfaces = new HashMap<Object, Interface>();
            EList ownedInterfaceImplementations = ((LogicalComponent)decompositionComponent.getValue()).getOwnedInterfaceImplementations();
            for (InterfaceImplementation interfaceImplementation : ownedInterfaceImplementations) {
                usedAndImpInterfaces.put(interfaceImplementation, interfaceImplementation.getImplementedInterface());
            }
            EList ownedInterfaceUses = ((LogicalComponent)decompositionComponent.getValue()).getOwnedInterfaceUses();
            for (InterfaceUse interfaceUse : ownedInterfaceUses) {
                usedAndImpInterfaces.put(interfaceUse, interfaceUse.getUsedInterface());
            }
            List items = decompositionComponent.getItems();
            ArrayList<Interface> interfaces = new ArrayList<Interface>();
            for (DecompositionItem decompositionItem : items) {
                Object value = decompositionItem.getValue();
                if (value == null || !(value instanceof Interface)) continue;
                interfaces.add((Interface)value);
            }
            if (items == null || items.isEmpty()) {
                for (EObject eObject : usedAndImpInterfaces.keySet()) {
                    valueme = decompositionComponent.getValue();
                    if (!(valueme instanceof LogicalComponent)) continue;
                    lc = (LogicalComponent)valueme;
                    if (eObject instanceof InterfaceUse) {
                        lc.getOwnedInterfaceUses().remove((Object)eObject);
                    }
                    if (!(eObject instanceof InterfaceImplementation)) continue;
                    lc.getOwnedInterfaceImplementations().remove((Object)eObject);
                }
                continue;
            }
            for (EObject eObject : usedAndImpInterfaces.keySet()) {
                if (interfaces.contains(usedAndImpInterfaces.get(eObject)) || !((valueme = decompositionComponent.getValue()) instanceof LogicalComponent)) continue;
                lc = (LogicalComponent)valueme;
                if (eObject instanceof InterfaceUse) {
                    lc.getOwnedInterfaceUses().remove((Object)eObject);
                }
                if (!(eObject instanceof InterfaceImplementation)) continue;
                lc.getOwnedInterfaceImplementations().remove((Object)eObject);
            }
        }
    }

    private List<DecompositionComponent> removeLCs(DecompositionModel model, LogicalComponent sourceLC) {
        EList subLogicalComponents = sourceLC.getSubLogicalComponents();
        BasicEList targetLcs = new BasicEList();
        Decomposition decompositionFirst = (Decomposition)model.getDecompositions().get(0);
        List targetComponents = decompositionFirst.getTargetComponents();
        for (DecompositionComponent decompositionComponent : targetComponents) {
            LogicalComponent lc2 = (LogicalComponent)decompositionComponent.getValue();
            targetLcs.add((Object)lc2);
        }
        boolean isReused = false;
        ArrayList<LogicalComponent> lcsTORemove = new ArrayList<LogicalComponent>();
        for (LogicalComponent lc1 : subLogicalComponents) {
            EObject container;
            EList abstractTypedElements;
            if (lc1.getAbstractTypedElements().size() > 1) {
                isReused = true;
            }
            if (!this.isMultipartDriven((ModelElement)sourceLC)) {
                AbstractTypedElement abstractTypedElement2;
                if (!targetLcs.contains((Object)lc1) && !isReused) {
                    abstractTypedElements = lc1.getAbstractTypedElements();
                    for (AbstractTypedElement abstractTypedElement2 : abstractTypedElements) {
                        abstractTypedElement2.destroy();
                    }
                    EObject container2 = lc1.eContainer();
                    if (container2 instanceof LogicalComponent) {
                        lcsTORemove.add(lc1);
                    }
                }
                if (!targetLcs.contains((Object)lc1) && isReused) {
                    abstractTypedElements = lc1.getAbstractTypedElements();
                    for (AbstractTypedElement abstractTypedElement2 : abstractTypedElements) {
                        container = abstractTypedElement2.eContainer();
                        if (container == null || !container.equals(sourceLC)) continue;
                        abstractTypedElement2.destroy();
                    }
                }
                abstractTypedElement2 = lcsTORemove.iterator();
                while (abstractTypedElement2.hasNext()) {
                    LogicalComponent containerLC;
                    LogicalComponent logicalComponent = (LogicalComponent)abstractTypedElement2.next();
                    EObject container3 = logicalComponent.eContainer();
                    if (container3 == null) continue;
                    if (container3 instanceof LogicalComponent) {
                        containerLC = (LogicalComponent)container3;
                        containerLC.getOwnedLogicalComponents().remove((Object)logicalComponent);
                        continue;
                    }
                    if (!(container3 instanceof LogicalComponentPkg)) continue;
                    containerLC = (LogicalComponentPkg)container3;
                    containerLC.getOwnedLogicalComponents().remove((Object)logicalComponent);
                }
            } else {
                if (!targetLcs.contains((Object)lc1) && !isReused) {
                    abstractTypedElements = lc1.getAbstractTypedElements();
                    for (AbstractTypedElement abstractTypedElement2 : abstractTypedElements) {
                        abstractTypedElement2.destroy();
                    }
                }
                if (!targetLcs.contains((Object)lc1) && isReused) {
                    abstractTypedElements = lc1.getAbstractTypedElements();
                    for (AbstractTypedElement abstractTypedElement2 : abstractTypedElements) {
                        container = abstractTypedElement2.eContainer();
                        if (container == null || !abstractTypedElement2.eContainer().equals(sourceLC)) continue;
                        abstractTypedElement2.destroy();
                    }
                }
            }
            isReused = false;
        }
        return targetComponents;
    }

    private void addSubLCs(final Decomposition decomposition, final LogicalComponent sourceComponent) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                LCDecompositionOperations.this.addTargetComponents(decomposition, sourceComponent, null, false);
            }

            public String getName() {
                return sourceComponent.getName();
            }
        };
        TransactionHelper.getExecutionManager((EObject)sourceComponent).execute((ICommand)command);
    }

    private void addLCDcmpsToLogicalComponent(final List<Decomposition> decompositions, final LogicalComponent sourceComponent) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                EList ll = sourceComponent.getSubLogicalComponents();
                sourceComponent.getSubLogicalComponents().remove((Object)ll);
                for (Decomposition decomp : decompositions) {
                    Object value = decomp.getValue();
                    LogicalArchitecture arch = null;
                    if (value == null || value.equals(Decomposition.DUMMY_VALUE)) {
                        arch = LaFactory.eINSTANCE.createLogicalArchitecture();
                        decomp.setValue((Object)arch);
                    } else {
                        arch = (LogicalArchitecture)value;
                    }
                    arch.setName(decomp.getName());
                    if (!sourceComponent.getOwnedLogicalArchitectures().contains((Object)arch)) {
                        sourceComponent.getOwnedLogicalArchitectures().add((Object)arch);
                    }
                    LCDecompositionOperations.this.addTargetComponents(decomp, null, arch, true);
                }
                sourceComponent.getOwnedLogicalArchitectures().remove(LCDecompositionOperations.this.getRemovedDecompositions(sourceComponent, decompositions));
                LCDecompositionOperations.this.moveAbstractCapabilityPkg((LogicalArchitecture)sourceComponent.getOwnedLogicalArchitectures().get(0), sourceComponent.getOwnedAbstractCapabilityPkg());
                sourceComponent.setOwnedAbstractCapabilityPkg(null);
            }

            public String getName() {
                return sourceComponent.getName();
            }
        };
        TransactionHelper.getExecutionManager((EObject)sourceComponent).execute((ICommand)command);
    }

    void moveAbstractCapabilityPkg(LogicalArchitecture arch, AbstractCapabilityPkg aspectPkg) {
        if (arch == null || aspectPkg == null) {
            return;
        }
        arch.setOwnedAbstractCapabilityPkg(aspectPkg);
    }

    void moveAbstractCapabilityPkg(LogicalComponent cpnt, AbstractCapabilityPkg aspectPkg) {
        if (cpnt == null || aspectPkg == null) {
            return;
        }
        cpnt.setOwnedAbstractCapabilityPkg(aspectPkg);
    }

    void addTargetComponents(Decomposition decomposition, LogicalComponent sourceComponent, LogicalArchitecture logArch, boolean isAlternateDecomposition) {
        for (DecompositionComponent comp : decomposition.getTargetComponents()) {
            if (comp.isReusedComponent()) {
                LogicalComponent value = (LogicalComponent)comp.getValue();
                LogicalComponent target = (LogicalComponent)comp.getReusedTarget();
                if (comp.isTrigger()) {
                    if (value == null) continue;
                    this.addComponentInstanceToLC2(sourceComponent, value, comp, true);
                    continue;
                }
                if (value == null) continue;
                this.addComponentInstanceToLC2(sourceComponent, value, comp, false);
                continue;
            }
            LogicalComponent lc = (LogicalComponent)comp.getValue();
            boolean isLcNew = false;
            if (lc == null) {
                lc = LaFactory.eINSTANCE.createLogicalComponent(comp.getName());
                comp.setValue((Object)lc);
                isLcNew = true;
            }
            if (!isLcNew && comp.isTrigger()) {
                for (AbstractTypedElement abstractTypedElement : lc.getAbstractTypedElements()) {
                    abstractTypedElement.setName(comp.getName());
                }
            }
            if (!isAlternateDecomposition && !sourceComponent.getSubLogicalComponents().contains((Object)lc)) {
                this.addComponentInstanceToLC(sourceComponent, lc);
                sourceComponent.getOwnedLogicalComponents().add((Object)lc);
            }
            ArrayList<DecompositionItem> interfaceItems = new ArrayList<DecompositionItem>();
            ArrayList<DecompositionItem> communicationLinkItems = new ArrayList<DecompositionItem>();
            for (DecompositionItem item : comp.getItems()) {
                Object value = item.getValue();
                if (value instanceof CommunicationLink) {
                    communicationLinkItems.add(item);
                    continue;
                }
                interfaceItems.add(item);
            }
            this.updateInternalInterfaces(interfaceItems, lc);
            this.updateInterfacesLinks(interfaceItems, lc);
            this.updateCommunicationLinks(communicationLinkItems, lc);
        }
    }

    private void updateCommunicationLinks(List<DecompositionItem> communicationLinkItems, LogicalComponent lc) {
        ArrayList<CommunicationLink> communicationLinks = new ArrayList<CommunicationLink>();
        for (DecompositionItem item : communicationLinkItems) {
            communicationLinks.add((CommunicationLink)item.getValue());
        }
        ArrayList intersection = new ArrayList(communicationLinks);
        intersection.retainAll((Collection<?>)lc.getOwnedCommunicationLinks());
        ArrayList toBeCloned = new ArrayList(communicationLinks);
        toBeCloned.removeAll(intersection);
        ArrayList toBeRemoved = new ArrayList(lc.getOwnedCommunicationLinks());
        toBeRemoved.removeAll(intersection);
        for (CommunicationLink link : toBeCloned) {
            CommunicationLink clone = CommunicationFactory.eINSTANCE.createCommunicationLink();
            clone.setExchangeItem(link.getExchangeItem());
            clone.setKind(link.getKind());
            clone.setProtocol(link.getProtocol());
            lc.getOwnedCommunicationLinks().add((Object)clone);
            CapellaElementExt.creationService((EObject)clone);
        }
        for (CommunicationLink link : toBeRemoved) {
            new CapellaDeleteCommand(ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)TransactionHelper.getEditingDomain((EObject)link)), Collections.singleton(link), true, false, false).execute();
        }
    }

    private void updateInternalInterfaces(List<DecompositionItem> ItemInterfacelist, LogicalComponent lc) {
        for (DecompositionItem itemItf : ItemInterfacelist) {
            if (!itemItf.isInternal()) continue;
            ArrayList<ExchangeItemAllocation> operationsAvailable = new ArrayList<ExchangeItemAllocation>();
            Interface itf = this.updateInternalInterface(lc, itemItf);
            this.updateExchangeItems(itemItf, operationsAvailable, itf);
            this.removeUnvailableExchangeItems(operationsAvailable, itf);
        }
    }

    private void updateExchangeItems(DecompositionItem itemItf, List<ExchangeItemAllocation> operationsAvailable, Interface itf) {
        for (DecompositionItemService itemSce : itemItf.getServiceItems()) {
            ExchangeItemAllocation opOrigin = null;
            ExchangeItemAllocation opCopy = null;
            ExchangeItemAllocation op = (ExchangeItemAllocation)itemSce.getValue();
            if (!itf.getOwnedExchangeItemAllocations().contains((Object)op)) {
                opOrigin = op;
                opCopy = InterfaceExt.addExchangeItem((Interface)itf, (ExchangeItem)opOrigin.getAllocatedItem());
                RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)opCopy, (NamedElement)opOrigin);
            } else {
                opCopy = op;
                List listMelo = RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)opCopy, (EClass)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION);
                if (listMelo.size() != 0) {
                    opOrigin = (ExchangeItemAllocation)listMelo.get(0);
                } else if (!this.isRefinementTraceExist(opCopy)) {
                    operationsAvailable.add(opCopy);
                }
            }
            if (opCopy == null || opOrigin == null) continue;
            this.updateExchangeItemProperties(opCopy, opOrigin);
            operationsAvailable.add(opCopy);
        }
    }

    private boolean isRefinementTraceExist(ExchangeItemAllocation opCopy) {
        for (AbstractTrace lnk : opCopy.getIncomingTraces()) {
            if (!(lnk instanceof RefinementLink)) continue;
            return true;
        }
        return false;
    }

    private boolean isRefinementTraceExist(TraceableElement from, TraceableElement to) {
        for (AbstractTrace lnk : to.getIncomingTraces()) {
            if (!(lnk instanceof RefinementLink) || !lnk.getSourceElement().equals(from)) continue;
            return true;
        }
        return false;
    }

    private Interface updateInternalInterface(LogicalComponent lc, DecompositionItem itemItf) {
        Interface itf;
        InterfacePkg itfPkg = lc.getOwnedInterfacePkg();
        if (itfPkg == null) {
            itfPkg = CsFactory.eINSTANCE.createInterfacePkg("Interfaces");
            lc.setOwnedInterfacePkg(itfPkg);
        }
        if (itemItf.getValue() == null) {
            itf = CsFactory.eINSTANCE.createInterface(itemItf.getName());
            itfPkg.getOwnedInterfaces().add((Object)itf);
            for (Object obj : itemItf.getOriginInterfaces()) {
                RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)itf, (NamedElement)((NamedElement)obj));
            }
            itemItf.setValue((Object)itf);
        } else {
            itf = (Interface)itemItf.getValue();
            itf.setName(itemItf.getName());
            for (Object obj : itemItf.getOriginInterfaces()) {
                if (this.isRefinementTraceExist((TraceableElement)itf, (TraceableElement)obj)) continue;
                RefinementLinkExt.createRefinementTraceabilityLink((NamedElement)itf, (NamedElement)((NamedElement)obj));
            }
        }
        return itf;
    }

    private void removeUnvailableExchangeItems(List<ExchangeItemAllocation> operationsAvailable, Interface itf) {
        ArrayList<ExchangeItemAllocation> opToRemove = new ArrayList<ExchangeItemAllocation>();
        for (ExchangeItemAllocation op : itf.getOwnedExchangeItemAllocations()) {
            if (operationsAvailable.contains(op)) continue;
            opToRemove.add(op);
        }
        for (ExchangeItemAllocation op : opToRemove) {
            if (!itf.getOwnedExchangeItemAllocations().contains((Object)op)) continue;
            CapellaElementExt.cleanTraces((CapellaElement)op);
            itf.getOwnedExchangeItemAllocations().remove((Object)op);
        }
    }

    private void updateExchangeItemProperties(ExchangeItemAllocation opCopy, ExchangeItemAllocation opOrigin) {
        opCopy.setName(opOrigin.getName());
        this.cloneNotes((CapellaElement)opOrigin, (CapellaElement)opCopy);
        opCopy.setReceiveProtocol(opOrigin.getReceiveProtocol());
        opCopy.setSendProtocol(opOrigin.getSendProtocol());
    }

    private void cloneNotes(CapellaElement capellaEltOrigin, CapellaElement capellaEltCopy) {
        capellaEltCopy.setDescription(capellaEltOrigin.getDescription());
        capellaEltCopy.setSummary(capellaEltOrigin.getSummary());
    }

    void addComponentInstanceToLC(LogicalComponent component) {
        Part instance = CsFactory.eINSTANCE.createPart(component.getName());
        component.getOwnedFeatures().add((Object)instance);
        instance.setAbstractType((AbstractType)component);
    }

    void addComponentInstanceToLC(LogicalComponent parent, LogicalComponent component) {
        Part instance = CsFactory.eINSTANCE.createPart(component.getName());
        parent.getOwnedFeatures().add((Object)instance);
        instance.setAbstractType((AbstractType)component);
    }

    void addComponentInstanceToLC2(LogicalComponent parent, LogicalComponent component, DecompositionComponent comp, boolean compName) {
        Part partInstance = null;
        if (component.getAbstractTypedElements() != null && !component.getAbstractTypedElements().isEmpty()) {
            if (compName) {
                partInstance = CsFactory.eINSTANCE.createPart(comp.getName());
                EList abstractTypedElements = component.getAbstractTypedElements();
                for (AbstractTypedElement abstractTypedElement : abstractTypedElements) {
                    abstractTypedElement.setName(comp.getName());
                }
            } else {
                partInstance = CsFactory.eINSTANCE.createPart(((AbstractTypedElement)component.getAbstractTypedElements().get(0)).getName());
            }
        } else {
            partInstance = compName ? CsFactory.eINSTANCE.createPart(comp.getName()) : CsFactory.eINSTANCE.createPart(component.getName());
        }
        parent.getOwnedFeatures().add((Object)partInstance);
        partInstance.setAbstractType((AbstractType)component);
    }

    List<LogicalComponent> getRemovedTargetComponents(LogicalComponent sourceComp, Decomposition decomposition) {
        ArrayList<LogicalComponent> removedComponents = new ArrayList<LogicalComponent>(1);
        for (LogicalComponent lc : sourceComp.getSubLogicalComponents()) {
            boolean flag = true;
            for (DecompositionComponent comp : decomposition.getTargetComponents()) {
                Object obj = comp.getValue();
                if (obj == null || !obj.equals(lc)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            removedComponents.add(lc);
        }
        return removedComponents;
    }

    List<LogicalArchitecture> getRemovedDecompositions(LogicalComponent sourceComp, List<Decomposition> decompositions) {
        ArrayList<LogicalArchitecture> removedComponents = new ArrayList<LogicalArchitecture>(1);
        for (LogicalArchitecture arch : sourceComp.getOwnedLogicalArchitectures()) {
            boolean flag = true;
            for (Decomposition decomp : decompositions) {
                if (decomp.getValue() == null || !decomp.getValue().equals(arch)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            removedComponents.add(arch);
        }
        return removedComponents;
    }

    List<LogicalComponent> getRemovedLCsFromDecomposition(Decomposition decomposition) {
        ArrayList<LogicalComponent> removedComponents = new ArrayList<LogicalComponent>(1);
        LogicalArchitecture logArch = (LogicalArchitecture)decomposition.getValue();
        boolean flag = true;
        for (DecompositionComponent comp : decomposition.getTargetComponents()) {
            Object obj = comp.getValue();
            if (obj == null || !obj.equals(logArch.getOwnedLogicalComponent())) continue;
            flag = false;
            break;
        }
        if (flag) {
            removedComponents.add(logArch.getOwnedLogicalComponent());
        }
        return removedComponents;
    }

    void updateInterfacesLinks(List<DecompositionItem> pairs, LogicalComponent lc) {
        for (DecompositionItem pair : pairs) {
            Interface inter = (Interface)pair.getValue();
            if (pair.isInterfaceUsage()) {
                boolean alreadyUsed = false;
                for (InterfaceUse use : lc.getUsedInterfaceLinks()) {
                    if (use.getUsedInterface() == null || !use.getUsedInterface().equals(inter)) continue;
                    alreadyUsed = true;
                    break;
                }
                if (alreadyUsed) continue;
                InterfaceUse interfaceUse = CsFactory.eINSTANCE.createInterfaceUse();
                interfaceUse.setUsedInterface(inter);
                lc.getOwnedInterfaceUses().add((Object)interfaceUse);
                continue;
            }
            boolean alreadyImplemented = false;
            for (InterfaceImplementation impl : lc.getImplementedInterfaceLinks()) {
                if (impl.getImplementedInterface() == null || !impl.getImplementedInterface().equals(inter)) continue;
                alreadyImplemented = true;
                break;
            }
            if (alreadyImplemented) continue;
            InterfaceImplementation interfaceImpl = CsFactory.eINSTANCE.createInterfaceImplementation();
            interfaceImpl.setImplementedInterface(inter);
            lc.getOwnedInterfaceImplementations().add((Object)interfaceImpl);
        }
        this.removeInternalInterfacesSelectedByButton();
        this.removeUnusedInterfaces(lc, pairs);
        this.removeUnImplementedInterfaces(lc, pairs);
    }

    private void removeInternalInterfacesSelectedByButton() {
        for (DecompositionItem decItem : this._controller.getModel().getDecompositionItemRemoved()) {
            if (decItem.getValue() == null) continue;
            Interface itfToRemove = (Interface)decItem.getValue();
            this.cleanInternalInterface(itfToRemove, true);
        }
    }

    void removeUnusedInterfaces(LogicalComponent lc, List<DecompositionItem> pairs) {
        ArrayList<InterfaceUse> unusedInterfaces = new ArrayList<InterfaceUse>();
        for (InterfaceUse interfaceUse : lc.getUsedInterfaceLinks()) {
            boolean flag = true;
            for (DecompositionItem pair : pairs) {
                if (!pair.getValue().equals(interfaceUse.getUsedInterface())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            unusedInterfaces.add(interfaceUse);
        }
        for (InterfaceUse useLink : unusedInterfaces) {
            this.cleanInternalInterface(useLink.getUsedInterface(), false);
        }
        lc.getOwnedInterfaceUses().remove(unusedInterfaces);
    }

    private void cleanInternalInterface(Interface anInterface, boolean cleanAll) {
        if (RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)anInterface, (EClass)CsPackage.Literals.INTERFACE).size() != 0) {
            ArrayList<ExchangeItemAllocation> listOpToRemove = new ArrayList<ExchangeItemAllocation>();
            for (ExchangeItemAllocation currentOp : anInterface.getOwnedExchangeItemAllocations()) {
                if (!cleanAll && !this.isRefinementTraceExist(currentOp)) continue;
                listOpToRemove.add(currentOp);
            }
            for (ExchangeItemAllocation operation : listOpToRemove) {
                CapellaElementExt.cleanTraces((CapellaElement)operation);
                anInterface.getOwnedExchangeItemAllocations().remove((Object)operation);
            }
            if (cleanAll || anInterface.getOwnedExchangeItemAllocations().size() == 0) {
                CapellaElementExt.cleanTraces((CapellaElement)anInterface);
                InterfacePkg pkg = (InterfacePkg)anInterface.eContainer();
                pkg.getOwnedInterfaces().remove((Object)anInterface);
            }
        }
    }

    void removeUnImplementedInterfaces(LogicalComponent lc, List<DecompositionItem> pairs) {
        ArrayList<InterfaceImplementation> unimplementedInterfaces = new ArrayList<InterfaceImplementation>(1);
        for (InterfaceImplementation interfaceImpl : lc.getImplementedInterfaceLinks()) {
            boolean flag = true;
            for (DecompositionItem pair : pairs) {
                if (!pair.getValue().equals(interfaceImpl.getImplementedInterface())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            unimplementedInterfaces.add(interfaceImpl);
        }
        for (InterfaceImplementation implLink : unimplementedInterfaces) {
            this.cleanInternalInterface(implLink.getImplementedInterface(), false);
        }
        lc.getOwnedInterfaceImplementations().remove(unimplementedInterfaces);
    }

    public LCDecompositionController getController() {
        return this._controller;
    }

    public void setController(LCDecompositionController controller) {
        this._controller = controller;
    }

    private boolean isMultipartDriven(ModelElement element) {
        return CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)element));
    }
}

