/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.common.ui.wizards;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionController;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionValidateWizardPage;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionGeneralViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;

public class LCDecompositionWizardPage
extends WizardPage {
    private DecompositionModel _decompositionModel;
    private DecompositionGeneralViewer _decompositionGeneralViewer;
    private LCDecompositionController _controller;

    public LCDecompositionWizardPage(DecompositionModel decompositionModel_p) {
        this("Capella Logical Component Decomposition");
        this._decompositionModel = decompositionModel_p;
    }

    public LCDecompositionWizardPage(String pageName_p) {
        super(pageName_p);
        this.setTitle(pageName_p);
        this.setMessage("This editor displays the Capella Logical Component Decomposition");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent_p) {
        this._decompositionGeneralViewer = new DecompositionGeneralViewer(parent_p, this._decompositionModel, true, this.getSynchronizationModeSelected(this._decompositionModel), false);
        this._decompositionGeneralViewer.setSourceTreeContentProvider(false);
        this._decompositionGeneralViewer.addTreeTipListeners();
        this._decompositionGeneralViewer.setDialogPage((DialogPage)this);
        this.setControl((Control)this._decompositionGeneralViewer.getControl());
    }

    public IWizardPage getNextPage() {
        LCDecompositionValidateWizardPage page = (LCDecompositionValidateWizardPage)super.getNextPage();
        this._decompositionModel.refreshStatusForSynthesisCheck();
        page.getDecompositionGeneralViewer().refreshItems(null);
        page.getDecompositionGeneralViewer().addTreeSelectionListener();
        return page;
    }

    public boolean canFlipToNextPage() {
        boolean flag = this._controller.canFlipToNextPage();
        return flag;
    }

    public LCDecompositionController getController() {
        return this._controller;
    }

    public void setController(LCDecompositionController controller_p) {
        this._controller = controller_p;
    }

    public DecompositionModel getDecompositionModel() {
        return this._decompositionModel;
    }

    public void setDecompositionModel(DecompositionModel decompositionModel_p) {
        this._decompositionModel = decompositionModel_p;
    }

    private boolean getSynchronizationModeSelected(DecompositionModel decompositionModel_p) {
        Object value;
        DecompositionComponent component;
        boolean result = true;
        if (decompositionModel_p != null && (component = decompositionModel_p.getSourceComponent()) != null && (value = component.getValue()) != null && value instanceof ModelElement) {
            ModelElement sourceElement = (ModelElement)value;
            result = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isSingletonComponentsDriven((EObject)sourceElement));
        }
        return result;
    }
}

