/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.af;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.af.integration.Messages;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.MigrationRunnable;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contributor.AbstractMigrationContributor;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;

public class MetadataUpdateContributor
extends AbstractMigrationContributor {
    @Override
    public String getKind() {
        return "MIGRATION_KIND__AFM";
    }

    @Override
    public boolean isValidResource(IResource member) {
        return CapellaResourceHelper.isAirdResource((IResource)member, (boolean)true);
    }

    @Override
    public AbstractMigrationRunnable getRunnable(IFile file) {
        return new MigrationRunnable(file){

            @Override
            public String getName() {
                return Messages.MetadataUpdateContributor_Name;
            }

            @Override
            protected void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) throws IOException {
                Resource resource = resourceSet.getResource(EcoreUtil2.getURI((IFile)this.getFile()), true);
                Resource initMetadata = MetadataHelper.initMetadata((Resource)resource);
                if (initMetadata != null) {
                    boolean found = false;
                    EObject eObject = (EObject)resource.getContents().get(0);
                    DAnalysis session = (DAnalysis)eObject;
                    ResourceDescriptor descriptor = new ResourceDescriptor(initMetadata.getURI());
                    URI descriptorURI = descriptor.getResourceURI();
                    EList semanticResources = session.getSemanticResources();
                    for (ResourceDescriptor semanticResource : semanticResources) {
                        URI semanticResourceURI = semanticResource.getResourceURI();
                        String str = URI.encodeFragment((String)semanticResourceURI.toString(), (boolean)true);
                        if (!str.equals(descriptorURI.toString())) continue;
                        found = true;
                    }
                    if (!found) {
                        semanticResources.add((Object)new ResourceDescriptor(initMetadata.getURI()));
                    }
                }
            }

            @Override
            public XMLResource doCreateResource(URI uri, MigrationContext context) {
                return null;
            }
        };
    }
}

