/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileVersionSAXParser;
import org.polarsys.capella.core.data.migration.aird.Messages;
import org.polarsys.capella.core.data.migration.capella.ModelMigrationRunnable;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.kitalpha.emde.xmi.XMIExtensionHelperImpl;

public class AirdMigrationRunnable
extends ModelMigrationRunnable {
    static final String FORMAT_UTF8 = "UTF-8";

    public AirdMigrationRunnable(IFile file) {
        super(file);
    }

    @Override
    public String getName() {
        return Messages.MigrationAction_DiagramMigration;
    }

    static boolean isAirdFile(URI uri) {
        boolean res = uri != null && ("aird".equals(uri.fileExtension()) || "airdfragment".equals(uri.fileExtension()));
        return res;
    }

    @Override
    public XMLResource doCreateResource(URI uri, final MigrationContext context) {
        if (AirdMigrationRunnable.isAirdFile(uri)) {
            GMFResource result = new GMFResource(uri){

                protected XMIExtensionHelperImpl createXMLHelper() {
                    return AirdMigrationRunnable.this.createCapellaXMLHelper((XMLResource)this);
                }

                protected XMLLoad createXMLLoad() {
                    return AirdMigrationRunnable.this.createCustomizedHandler(this.createXMLHelper(), context);
                }

                protected void init() {
                    super.init();
                    RepresentationsFileVersionSAXParser parser = new RepresentationsFileVersionSAXParser(this.getURI());
                    String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
                    this.getDefaultLoadOptions().put("VERSION", loadedVersion);
                    this.getDefaultSaveOptions().put("ENCODING", AirdMigrationRunnable.FORMAT_UTF8);
                    this.getDefaultLoadOptions().put("ENCODING", AirdMigrationRunnable.FORMAT_UTF8);
                    this.getDefaultSaveOptions().put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
                    this.getDefaultSaveOptions().put("USE_FILE_BUFFER", Boolean.TRUE);
                    this.getDefaultSaveOptions().put("FLUSH_THRESHOLD", 0x1000000);
                    this.getDefaultLoadOptions().putAll(GMFResourceFactory.getDefaultLoadOptions());
                    this.getDefaultSaveOptions().putAll(GMFResourceFactory.getDefaultSaveOptions());
                    this.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    if (!this.getEncoding().equals(AirdMigrationRunnable.FORMAT_UTF8)) {
                        this.setEncoding(AirdMigrationRunnable.FORMAT_UTF8);
                    }
                }
            };
            return result;
        }
        return super.doCreateResource(uri, context);
    }
}

