/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.capella;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.polarsys.capella.common.bundle.FeatureHelper;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.behavior.BehaviorPackage;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.libraries.LibrariesPackage;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.migration.capella.Messages;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.deployment.DeploymentPackage;
import org.polarsys.capella.core.data.requirement.RequirementPackage;
import org.polarsys.capella.core.data.sharedmodel.SharedmodelPackage;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaFeatureHelper;

public class CapellaMigrationContribution
extends AbstractMigrationContribution {
    public static HashMap<String, EPackage> prefixes = new HashMap();
    public static HashMap<String, EPackage> pkgs;

    static {
        prefixes.put("xmlns:org.polarsys.capella.core.data.cs", (EPackage)CsPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.ctx", (EPackage)CtxPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.epbs", (EPackage)EpbsPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.fa", (EPackage)FaPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.information", (EPackage)InformationPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.information.communication", (EPackage)CommunicationPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.information.datatype", (EPackage)DatatypePackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.information.datavalue", (EPackage)DatavaluePackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.interaction", (EPackage)InteractionPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.la", (EPackage)LaPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.common", (EPackage)CapellacommonPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.core", (EPackage)CapellacorePackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.modeller", (EPackage)CapellamodellerPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.oa", (EPackage)OaPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.pa", (EPackage)PaPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.pa.deployment", (EPackage)DeploymentPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.requirement", (EPackage)RequirementPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.core.data.sharedmodel", (EPackage)SharedmodelPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.common.activity", (EPackage)ActivityPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.common.behavior", (EPackage)BehaviorPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.common.core", (EPackage)ModellingcorePackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.common.libraries", (EPackage)LibrariesPackage.eINSTANCE);
        prefixes.put("xmlns:org.polarsys.capella.common.re", (EPackage)RePackage.eINSTANCE);
        pkgs = new HashMap();
        pkgs.put("http://www.polarsys.org/capella/core/cs/1.0.0", (EPackage)CsPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/ctx/1.0.0", (EPackage)CtxPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/epbs/1.0.0", (EPackage)EpbsPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/fa/1.0.0", (EPackage)FaPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/information/1.0.0", (EPackage)InformationPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/information/communication/1.0.0", (EPackage)CommunicationPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/information/datatype/1.0.0", (EPackage)DatatypePackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/information/datavalue/1.0.0", (EPackage)DatavaluePackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/interaction/1.0.0", (EPackage)InteractionPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/la/1.0.0", (EPackage)LaPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/common/1.0.0", (EPackage)CapellacommonPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/core/1.0.0", (EPackage)CapellacorePackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/modeller/1.0.0", (EPackage)CapellamodellerPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/oa/1.0.0", (EPackage)OaPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/pa/1.0.0", (EPackage)PaPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/pa/deployment/1.0.0", (EPackage)DeploymentPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/requirement/1.0.0", (EPackage)RequirementPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/core/sharedmodel/1.0.0", (EPackage)SharedmodelPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/common/activity/1.0.0", (EPackage)ActivityPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/common/behavior/1.0.0", (EPackage)BehaviorPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/common/core/1.0.0", (EPackage)ModellingcorePackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/common/libraries/1.0.0", (EPackage)LibrariesPackage.eINSTANCE);
        pkgs.put("http://www.polarsys.org/capella/common/re/1.0.0", (EPackage)RePackage.eINSTANCE);
    }

    @Override
    public IStatus preMigrationExecute(IResource fileToMigrate, MigrationContext context, boolean checkVersion) {
        if (CapellaResourceHelper.isCapellaResource((IResource)fileToMigrate) && checkVersion) {
            Version currentVersion = Version.parseVersion((String)CapellaMigrationContribution.getCurrentVersion());
            return this.isMigrationPossible(fileToMigrate, currentVersion, context);
        }
        return Status.OK_STATUS;
    }

    public static String getCurrentVersion() {
        String version = FeatureHelper.getCapellaVersion((boolean)false);
        String capellaCurrentVersion = version.substring(0, 5);
        return capellaCurrentVersion;
    }

    private IStatus isMigrationPossible(IResource fileToMigrate, Version currentVersion, MigrationContext context) {
        boolean isMigrationPossible;
        String fileToMigrateVersion;
        String detectedVersion = CapellaFeatureHelper.getDetectedVersion((IFile)((IFile)fileToMigrate));
        String string = fileToMigrateVersion = detectedVersion != null && !detectedVersion.isEmpty() ? detectedVersion.substring(0, 5) : null;
        if (fileToMigrateVersion == null) {
            String formattedMessage = NLS.bind((String)Messages.MigrationAction_ErrorDialog_CorruptedMessage, (Object[])new String[]{fileToMigrate.getFullPath().toString()});
            return new Status(4, "org.polarsys.capella.core.data.migration", formattedMessage);
        }
        Version fileVersion = Version.parseVersion(fileToMigrateVersion);
        boolean bl = isMigrationPossible = currentVersion.getMajor() == fileVersion.getMajor();
        if (isMigrationPossible && currentVersion.getMinor() - fileVersion.getMinor() > 1) {
            isMigrationPossible = false;
        }
        if (!isMigrationPossible && !this.isExceptionalCase(fileVersion, currentVersion)) {
            String formattedMessage = NLS.bind((String)Messages.MigrationAction_ErrorDialog_TooOldMessage, (Object[])new String[]{fileToMigrate.getFullPath().toString(), CapellaMigrationContribution.getCurrentVersion()});
            return new Status(4, "org.polarsys.capella.core.data.migration", formattedMessage);
        }
        return Status.OK_STATUS;
    }

    private boolean isExceptionalCase(Version fileVersion, Version currentVersion) {
        return fileVersion.getMajor() == 0 && fileVersion.getMinor() == 8 && currentVersion.getMajor() == 1 && currentVersion.getMinor() == 0;
    }

    @Override
    public void contributePackageRegistry(EPackage.Registry packageRegistry, MigrationContext context) {
        for (String oldNSURI : pkgs.keySet()) {
            packageRegistry.put((Object)oldNSURI, (Object)pkgs.get(oldNSURI));
        }
    }

    @Override
    public String getNSPrefix(String prefix, MigrationContext context) {
        if (prefixes.containsKey(prefix)) {
            return "xmlns:" + prefixes.get(prefix).getNsPrefix();
        }
        return null;
    }

    @Override
    public String getNSURI(String prefix, String nsUri, MigrationContext context) {
        if (pkgs.containsKey(nsUri)) {
            return pkgs.get(nsUri).getNsURI();
        }
        return null;
    }
}

