/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.cmdline;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.polarsys.capella.core.commandline.core.AbstractCommandLine;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.data.migration.MigrationConstants;
import org.polarsys.capella.core.data.migration.MigrationHelpers;

public class MigrationCommandLine
extends AbstractCommandLine {
    private Display display;

    public boolean projectVersionIsCompliant() throws CommandLineException {
        return true;
    }

    public boolean execute(IApplicationContext context) throws CommandLineException {
        this.display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return null;
            }

            public void postStartup() {
                super.postStartup();
                MigrationCommandLine.this.setRefreshPrefs();
                MigrationCommandLine.this.migrateAllImportedProjects();
                PlatformUI.getWorkbench().close();
            }
        });
        return true;
    }

    protected void migrateAllImportedProjects() {
        for (String projectName : this.getImportedProjects()) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                MigrationHelpers.getInstance().trigger((IResource)project, this.display.getActiveShell(), true, false, MigrationConstants.DEFAULT_KIND_ORDER);
            }
            catch (Exception e) {
                this.logError("Error during migration of " + projectName);
            }
        }
    }

    protected void setRefreshPrefs() {
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        preferenceStore.setValue(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        preferenceStore.setValue(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name(), true);
    }
}

