/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.data.migration.contribution.Messages;

public class BackupResourceContribution
extends AbstractMigrationContribution {
    Boolean _backupModels = null;

    @Override
    public void dispose(MigrationContext context) {
        super.dispose(context);
        this._backupModels = null;
    }

    @Override
    public IStatus preMigrationExecute(IResource fileToMigrate, final MigrationContext context, boolean checkVersion) {
        if (context.isSkipConfirmation()) {
            this._backupModels = Boolean.TRUE;
            return Status.OK_STATUS;
        }
        final IStatus[] result = new IStatus[]{Status.OK_STATUS};
        final Boolean[] state = new Boolean[]{Boolean.TRUE};
        if (this._backupModels == null) {
            context.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)context.getShell(), (String)Messages.MigrationAction_ConfirmationDialog_Title, (String)Messages.MigrationAction_ConfirmationDialog_Message, (String)Messages.MigrationAction_ConfirmationDialog_ToggleMessage, (boolean)true, null, null);
                    if (dialog.getReturnCode() != 0) {
                        result[0] = Status.CANCEL_STATUS;
                    }
                    state[0] = dialog.getToggleState();
                }
            });
            if (!result[0].isOK()) {
                return result[0];
            }
            this._backupModels = state[0];
        }
        return Status.OK_STATUS;
    }

    @Override
    public void preSaveResource(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        this.backupResource(resource, context.getProgressMonitor());
        super.preSaveResource(executionManager, resource, context);
    }

    protected void backupResource(Resource resource, IProgressMonitor monitor) {
        if (this._backupModels == Boolean.TRUE) {
            URI uri = resource.getResourceSet().getURIConverter().normalize(resource.getURI());
            String filePath = uri.toPlatformString(true);
            IFile inputXMI = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
            try {
                this.createBackupFile(inputXMI, monitor);
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected IFile createBackupFile(IFile file, IProgressMonitor monitor) throws CoreException {
        return this.createBackupFile(file, this.createTimestamp(), monitor);
    }

    protected IFile createBackupFile(IFile file, String timestamp, IProgressMonitor monitor) throws CoreException {
        IFile backup;
        int lastDotIndex = file.getName().lastIndexOf(46);
        String name = null;
        name = lastDotIndex > 0 ? String.valueOf(file.getName().substring(0, lastDotIndex)) + '-' + timestamp + '.' + file.getName().substring(lastDotIndex + ".".length()) + ".old" : String.valueOf(file.getName()) + '-' + timestamp + ".old";
        if (file.getParent().findMember(name, true) == null) {
            backup = file.getParent().getFile((IPath)new Path("/" + name));
        } else {
            int i = 2;
            while (file.getParent().findMember(String.valueOf(name) + i, true) != null) {
                ++i;
            }
            backup = file.getParent().getFile((IPath)new Path("/" + name + i));
        }
        assert (!backup.exists()) : "the file already exists";
        file.copy(backup.getFullPath(), 1, monitor);
        file.getParent().refreshLocal(1, monitor);
        return backup;
    }

    protected String createTimestamp() {
        return new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date());
    }
}

