/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.repair;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.api.repair.SiriusRepairProcess;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.af.integration.listener.MetadataCheckListener;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.MigrationHelpers;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.repair.Messages;

public class RepairSiriusRunnable
extends AbstractMigrationRunnable {
    public RepairSiriusRunnable(IFile file) {
        super(file);
    }

    @Override
    public IStatus run(MigrationContext context, boolean checkVersion) {
        MetadataCheckListener.disable();
        try {
            try {
                LongRunningListenersRegistry.getInstance().operationStarting(this.getClass());
                this.doRepairMigrate(this.getName(), this.getFile(), context.isSkipConfirmation(), context);
            }
            catch (InterruptedException e) {
                LongRunningListenersRegistry.getInstance().operationAborted(this.getClass());
                IStatus iStatus = Status.CANCEL_STATUS;
                MetadataCheckListener.enable();
                LongRunningListenersRegistry.getInstance().operationEnded(this.getClass());
                context.getProgressMonitor().done();
                return iStatus;
            }
            catch (OutOfMemoryError error) {
                MigrationHelpers.getInstance().onOutOfMemoryError(error, context);
                throw error;
            }
        }
        finally {
            MetadataCheckListener.enable();
            LongRunningListenersRegistry.getInstance().operationEnded(this.getClass());
            context.getProgressMonitor().done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getName() {
        return Messages.MigrationAction_RepairMigration;
    }

    protected void doRepairMigrate(String actionName, IFile file, boolean backup, MigrationContext context) throws InterruptedException {
        SiriusRepairProcess process = new SiriusRepairProcess(file, backup);
        context.getProgressMonitor().setTaskName(this.getName());
        process.run(context.getProgressMonitor());
    }
}

