/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.releng;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.polarsys.kitalpha.releng.AbstractTask;

public class CustomPlatformAntTask
extends AbstractTask {
    private String platformPath;
    private String buildId;
    private String application;
    private String product;

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setPlatformPath(String platformPath) {
        this.platformPath = platformPath;
    }

    public void execute() throws BuildException {
        System.out.println("Starting custom of " + this.platformPath);
        try {
            this.modifyEclipseInis();
            this.modifyConfigIni();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void modifyConfigIni() throws IOException {
        File file = new File(this.platformPath, "configuration/config.ini");
        System.out.println("Will modify " + file.getName());
        ArrayList<String> list = new ArrayList<String>();
        this.readFile(file, list);
        for (String line : new ArrayList<String>(list)) {
            if (line.startsWith("eclipse.product")) {
                list.set(list.indexOf(line), "eclipse.product=" + this.product);
            }
            if (line.startsWith("osgi.splashPath")) {
                list.set(list.indexOf(line), "osgi.splashPath=platform\\:/base/plugins/" + this.product);
            }
            if (!line.startsWith("eclipse.application")) continue;
            list.set(list.indexOf(line), "eclipse.application=" + this.application);
        }
        this.writeFile(file, list);
    }

    private void modifyEclipseInis() throws IOException {
        File folder = new File(this.platformPath);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith("eclipse") && file.getName().endsWith(".ini")) {
                System.out.println("Will modify " + file.getName());
                ArrayList<String> list = new ArrayList<String>();
                this.readFile(file, list);
                list.add(0, "-showLocation");
                for (String line : new ArrayList<String>(list)) {
                    if (line.startsWith("-Xms") || line.startsWith("-Xmx")) {
                        list.remove(line);
                    }
                    if (!line.equals("org.eclipse.platform")) continue;
                    list.set(list.indexOf(line), this.product);
                }
                list.add("-Dosgi.requiredJavaVersion=1.5");
                list.add("-Xms128m");
                list.add("-Xmx512m");
                list.add("-XX:PermSize=64M");
                list.add("-XX:MaxPermSize=512M");
                this.writeFile(file, list);
            }
            ++n2;
        }
    }
}

