/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WorkspaceResourceDialog
extends Dialog {
    protected final List<String> extensions;
    private final List<IResource> selectedResources = new ArrayList<IResource>();
    private final int selectionStyle;
    private final String title;
    private TreeViewer viewer;

    public WorkspaceResourceDialog(Shell parent, int style, String dialogTitle) {
        this(parent, style, dialogTitle, null);
    }

    public WorkspaceResourceDialog(Shell parent, int style, String dialogTitle, List<String> fileExtensions) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = dialogTitle;
        this.extensions = fileExtensions;
        this.selectionStyle = style == 2 || style == 4 ? style : 4;
    }

    public List<IResource> getSelectedResources() {
        if (this.getReturnCode() == 0) {
            return this.selectedResources;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        this.createViewer(composite);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 400;
        data.widthHint = 300;
        this.viewer.getControl().setLayoutData((Object)data);
        return composite;
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, this.selectionStyle | 0x100 | 0x200 | 0x800);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.viewer.addFilter((ViewerFilter)new FileExtensionFilter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!WorkspaceResourceDialog.this.viewer.getControl().isDisposed()) {
                    WorkspaceResourceDialog.this.validate();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                WorkspaceResourceDialog.this.validate();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (WorkspaceResourceDialog.this.validate()) {
                    WorkspaceResourceDialog.this.okPressed();
                }
            }
        });
    }

    public boolean validate() {
        this.selectedResources.clear();
        ISelection selection = this.viewer.getSelection();
        ArrayList<IResource> result = new ArrayList<IResource>();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)selection) {
                IResource resource;
                if (next instanceof IResource) {
                    result.add((IResource)next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || (resource = (IResource)((IAdaptable)next).getAdapter(IResource.class)) == null) continue;
                result.add(resource);
            }
        }
        int i = 0;
        while (i < result.size()) {
            if (((IResource)result.get(i)).getType() == 1) {
                this.selectedResources.add((IResource)result.get(i));
            }
            ++i;
        }
        this.getButton(0).setEnabled(this.selectedResources.size() > 0);
        return this.selectedResources.size() > 0;
    }

    private class FileExtensionFilter
    extends ViewerFilter {
        public boolean select(Viewer theViewer, Object parentElement, Object element) {
            if (WorkspaceResourceDialog.this.extensions == null || WorkspaceResourceDialog.this.extensions.size() == 0 || WorkspaceResourceDialog.this.extensions.contains("*")) {
                return true;
            }
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
            boolean isValid = false;
            if (resource != null && !resource.isDerived()) {
                if (resource.getType() == 2 || resource.getType() == 4) {
                    try {
                        IResource[] members;
                        IResource[] iResourceArray = members = ((IContainer)resource).members();
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            isValid = this.select(theViewer, parentElement, member);
                            if (!isValid) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (resource.getType() == 1) {
                    if (WorkspaceResourceDialog.this.extensions.size() > 0) {
                        int i = 0;
                        while (i < WorkspaceResourceDialog.this.extensions.size()) {
                            if (WorkspaceResourceDialog.this.extensions.get(i).toString().equalsIgnoreCase(resource.getFileExtension())) {
                                isValid = true;
                                break;
                            }
                            ++i;
                        }
                    } else {
                        isValid = true;
                    }
                }
            }
            return isValid;
        }
    }
}

