/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class MergeOperation
implements IEGitOperation {
    private final Repository repository;
    private final String refName;
    private final MergeStrategy mergeStrategy;
    private Boolean squash;
    private MergeCommand.FastForwardMode fastForwardMode;
    private Boolean commit;
    private MergeResult mergeResult;
    private String message;

    public MergeOperation(@NonNull Repository repository, @NonNull String refName) {
        this.repository = repository;
        this.refName = refName;
        this.mergeStrategy = Activator.getDefault().getPreferredMergeStrategy();
    }

    public MergeOperation(@NonNull Repository repository, @NonNull String refName, @NonNull String mergeStrategyName) {
        this.repository = repository;
        this.refName = refName;
        MergeStrategy strategy = null;
        strategy = MergeStrategy.get((String)mergeStrategyName);
        this.mergeStrategy = strategy != null ? strategy : Activator.getDefault().getPreferredMergeStrategy();
    }

    public void setSquash(boolean squash) {
        this.squash = squash;
    }

    public void setFastForwardMode(MergeCommand.FastForwardMode ffmode) {
        this.fastForwardMode = ffmode;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        if (this.mergeResult != null) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor mymonitor) throws CoreException {
                IProject[] validProjects = ProjectUtil.getValidOpenProjects(MergeOperation.this.repository);
                mymonitor.beginTask(NLS.bind((String)CoreText.MergeOperation_ProgressMerge, (Object)MergeOperation.this.refName), 3);
                Git git = new Git(MergeOperation.this.repository);
                mymonitor.worked(1);
                MergeCommand merge = git.merge();
                try {
                    Ref ref = MergeOperation.this.repository.getRef(MergeOperation.this.refName);
                    if (ref != null) {
                        merge.include(ref);
                    } else {
                        merge.include((AnyObjectId)ObjectId.fromString((String)MergeOperation.this.refName));
                    }
                }
                catch (IOException e) {
                    throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
                }
                if (MergeOperation.this.fastForwardMode != null) {
                    merge.setFastForward(MergeOperation.this.fastForwardMode);
                }
                if (MergeOperation.this.commit != null) {
                    merge.setCommit(MergeOperation.this.commit.booleanValue());
                }
                if (MergeOperation.this.squash != null) {
                    merge.setSquash(MergeOperation.this.squash.booleanValue());
                }
                if (MergeOperation.this.mergeStrategy != null) {
                    merge.setStrategy(MergeOperation.this.mergeStrategy);
                }
                if (MergeOperation.this.message != null) {
                    merge.setMessage(MergeOperation.this.message);
                }
                try {
                    try {
                        MergeOperation.this.mergeResult = merge.call();
                        mymonitor.worked(1);
                        if (MergeResult.MergeStatus.NOT_SUPPORTED.equals((Object)MergeOperation.this.mergeResult.getMergeStatus())) {
                            throw new TeamException((IStatus)new Status(1, Activator.getPluginId(), MergeOperation.this.mergeResult.toString()));
                        }
                    }
                    catch (NoHeadException e) {
                        throw new TeamException(CoreText.MergeOperation_MergeFailedNoHead, (Throwable)e);
                    }
                    catch (ConcurrentRefUpdateException e) {
                        throw new TeamException(CoreText.MergeOperation_MergeFailedRefUpdate, (Throwable)e);
                    }
                    catch (CheckoutConflictException e) {
                        MergeOperation.this.mergeResult = new MergeResult(e.getConflictingPaths());
                        ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(mymonitor, 1));
                        mymonitor.done();
                        return;
                    }
                    catch (GitAPIException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                }
                finally {
                    ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(mymonitor, 1));
                    mymonitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    public MergeResult getResult() {
        return this.mergeResult;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

