/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.componentPort;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;

public class MDCHK_ComponentPort_Orientation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        ComponentExchange exchange = (ComponentExchange)ctx.getTarget();
        ComponentPort sourceCompPort = null;
        ComponentPort targetCompPort = null;
        Port sourcePort = ComponentExchangeExt.getSourcePort((ComponentExchange)exchange);
        Port targetPort = ComponentExchangeExt.getTargetPort((ComponentExchange)exchange);
        if (sourcePort instanceof ComponentPort) {
            sourceCompPort = (ComponentPort)sourcePort;
        }
        if (targetPort instanceof ComponentPort) {
            targetCompPort = (ComponentPort)targetPort;
        }
        boolean delgation = false;
        ComponentExchangeKind kind = exchange.getKind();
        if (kind.equals((Object)ComponentExchangeKind.DELEGATION)) {
            delgation = true;
        }
        int result = 0;
        if (!delgation) {
            if (sourceCompPort != null && sourceCompPort.getOrientation() == OrientationPortKind.IN) {
                result = (byte)(result | 1);
            }
            if (targetCompPort != null && targetCompPort.getOrientation() == OrientationPortKind.OUT) {
                result = (byte)(result | 2);
            }
        } else if (sourceCompPort != null && targetCompPort != null && (sourceCompPort.getOrientation() == OrientationPortKind.IN && targetCompPort.getOrientation() == OrientationPortKind.OUT || sourceCompPort.getOrientation() == OrientationPortKind.OUT && targetCompPort.getOrientation() == OrientationPortKind.IN)) {
            result = 4;
        }
        switch (result) {
            case 1: {
                return ctx.createFailureStatus(new Object[]{"Orientation of source component port '" + sourceCompPort.getName() + "' cannot be 'IN'"});
            }
            case 2: {
                return ctx.createFailureStatus(new Object[]{"Orientation of target component port '" + targetCompPort.getName() + "' cannot be 'OUT'"});
            }
            case 3: {
                return ctx.createFailureStatus(new Object[]{"ComponentExchange '" + exchange.getName() + "' has inconsistent component port orientations"});
            }
            case 4: {
                return ctx.createFailureStatus(new Object[]{"ComponentExchange of kind Delegation '" + exchange.getName() + "' has inconsistent component port orientations"});
            }
        }
        return ctx.createSuccessStatus();
    }
}

